# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.swimlane_payload import SwimlanePayload
from typing import Optional, Set
from typing_extensions import Self

class SwimlanesPayload(BaseModel):
    """
    The payload for customising a swimlanes on a board
    """ # noqa: E501
    custom_swimlanes: Optional[List[SwimlanePayload]] = Field(default=None, description="The custom swimlane definitions.", alias="customSwimlanes")
    default_custom_swimlane_name: Optional[StrictStr] = Field(default=None, description="The name of the custom swimlane to use for work items that don't match any other swimlanes.", alias="defaultCustomSwimlaneName")
    swimlane_strategy: Optional[StrictStr] = Field(default=None, description="The swimlane strategy for the board.", alias="swimlaneStrategy")
    __properties: ClassVar[List[str]] = ["customSwimlanes", "defaultCustomSwimlaneName", "swimlaneStrategy"]

    @field_validator('swimlane_strategy')
    def swimlane_strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['none', 'custom', 'parentChild', 'assignee', 'assigneeUnassignedFirst', 'epic', 'project', 'issueparent', 'issuechildren', 'request_type']):
            raise ValueError("must be one of enum values ('none', 'custom', 'parentChild', 'assignee', 'assigneeUnassignedFirst', 'epic', 'project', 'issueparent', 'issuechildren', 'request_type')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SwimlanesPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_swimlanes (list)
        _items = []
        if self.custom_swimlanes:
            for _item_custom_swimlanes in self.custom_swimlanes:
                if _item_custom_swimlanes:
                    _items.append(_item_custom_swimlanes.to_dict())
            _dict['customSwimlanes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SwimlanesPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customSwimlanes": [SwimlanePayload.from_dict(_item) for _item in obj["customSwimlanes"]] if obj.get("customSwimlanes") is not None else None,
            "defaultCustomSwimlaneName": obj.get("defaultCustomSwimlaneName"),
            "swimlaneStrategy": obj.get("swimlaneStrategy")
        })
        return _obj


