# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TaskProgressBeanObject(BaseModel):
    """
    Details about a task.
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the task.")
    elapsed_runtime: StrictInt = Field(description="The execution time of the task, in milliseconds.", alias="elapsedRuntime")
    finished: Optional[StrictInt] = Field(default=None, description="A timestamp recording when the task was finished.")
    id: StrictStr = Field(description="The ID of the task.")
    last_update: StrictInt = Field(description="A timestamp recording when the task progress was last updated.", alias="lastUpdate")
    message: Optional[StrictStr] = Field(default=None, description="Information about the progress of the task.")
    progress: StrictInt = Field(description="The progress of the task, as a percentage complete.")
    result: Optional[Any] = Field(default=None, description="The result of the task execution.")
    var_self: StrictStr = Field(description="The URL of the task.", alias="self")
    started: Optional[StrictInt] = Field(default=None, description="A timestamp recording when the task was started.")
    status: StrictStr = Field(description="The status of the task.")
    submitted: StrictInt = Field(description="A timestamp recording when the task was submitted.")
    submitted_by: StrictInt = Field(description="The ID of the user who submitted the task.", alias="submittedBy")
    __properties: ClassVar[List[str]] = ["description", "elapsedRuntime", "finished", "id", "lastUpdate", "message", "progress", "result", "self", "started", "status", "submitted", "submittedBy"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ENQUEUED', 'RUNNING', 'COMPLETE', 'FAILED', 'CANCEL_REQUESTED', 'CANCELLED', 'DEAD']):
            raise ValueError("must be one of enum values ('ENQUEUED', 'RUNNING', 'COMPLETE', 'FAILED', 'CANCEL_REQUESTED', 'CANCELLED', 'DEAD')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TaskProgressBeanObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if result (nullable) is None
        # and model_fields_set contains the field
        if self.result is None and "result" in self.model_fields_set:
            _dict['result'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TaskProgressBeanObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "elapsedRuntime": obj.get("elapsedRuntime"),
            "finished": obj.get("finished"),
            "id": obj.get("id"),
            "lastUpdate": obj.get("lastUpdate"),
            "message": obj.get("message"),
            "progress": obj.get("progress"),
            "result": obj.get("result"),
            "self": obj.get("self"),
            "started": obj.get("started"),
            "status": obj.get("status"),
            "submitted": obj.get("submitted"),
            "submittedBy": obj.get("submittedBy")
        })
        return _obj


