# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class TimeTrackingConfiguration(BaseModel):
    """
    Details of the time tracking configuration.
    """ # noqa: E501
    default_unit: StrictStr = Field(description="The default unit of time applied to logged time.", alias="defaultUnit")
    time_format: StrictStr = Field(description="The format that will appear on an issue's *Time Spent* field.", alias="timeFormat")
    working_days_per_week: Union[StrictFloat, StrictInt] = Field(description="The number of days in a working week.", alias="workingDaysPerWeek")
    working_hours_per_day: Union[StrictFloat, StrictInt] = Field(description="The number of hours in a working day.", alias="workingHoursPerDay")
    __properties: ClassVar[List[str]] = ["defaultUnit", "timeFormat", "workingDaysPerWeek", "workingHoursPerDay"]

    @field_validator('default_unit')
    def default_unit_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['minute', 'hour', 'day', 'week']):
            raise ValueError("must be one of enum values ('minute', 'hour', 'day', 'week')")
        return value

    @field_validator('time_format')
    def time_format_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pretty', 'days', 'hours']):
            raise ValueError("must be one of enum values ('pretty', 'days', 'hours')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TimeTrackingConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TimeTrackingConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultUnit": obj.get("defaultUnit"),
            "timeFormat": obj.get("timeFormat"),
            "workingDaysPerWeek": obj.get("workingDaysPerWeek"),
            "workingHoursPerDay": obj.get("workingHoursPerDay")
        })
        return _obj


