# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.condition_group_payload import ConditionGroupPayload
from devopso.clients.jira_cloud.models.from_layout_payload import FromLayoutPayload
from devopso.clients.jira_cloud.models.rule_payload import RulePayload
from devopso.clients.jira_cloud.models.to_layout_payload import ToLayoutPayload
from typing import Optional, Set
from typing_extensions import Self

class TransitionPayload(BaseModel):
    """
    The payload for creating a transition in a workflow. Can be DIRECTED, GLOBAL, SELF-LOOPED, GLOBAL LOOPED
    """ # noqa: E501
    actions: Optional[List[RulePayload]] = Field(default=None, description="The actions that are performed when the transition is made")
    conditions: Optional[ConditionGroupPayload] = None
    custom_issue_event_id: Optional[StrictStr] = Field(default=None, description="Mechanism in Jira for triggering certain actions, like notifications, automations, etc. Unless a custom notification scheme is configure, it's better not to provide any value here", alias="customIssueEventId")
    description: Optional[StrictStr] = Field(default=None, description="The description of the transition")
    var_from: Optional[List[FromLayoutPayload]] = Field(default=None, description="The statuses that the transition can be made from", alias="from")
    id: Optional[StrictInt] = Field(default=None, description="The id of the transition")
    name: Optional[StrictStr] = Field(default=None, description="The name of the transition")
    properties: Optional[Dict[str, StrictStr]] = Field(default=None, description="The properties of the transition")
    to: Optional[ToLayoutPayload] = None
    transition_screen: Optional[RulePayload] = Field(default=None, alias="transitionScreen")
    triggers: Optional[List[RulePayload]] = Field(default=None, description="The triggers that are performed when the transition is made")
    type: Optional[StrictStr] = Field(default=None, description="The type of the transition")
    validators: Optional[List[RulePayload]] = Field(default=None, description="The validators that are performed when the transition is made")
    __properties: ClassVar[List[str]] = ["actions", "conditions", "customIssueEventId", "description", "from", "id", "name", "properties", "to", "transitionScreen", "triggers", "type", "validators"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['global', 'initial', 'directed']):
            raise ValueError("must be one of enum values ('global', 'initial', 'directed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransitionPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in actions (list)
        _items = []
        if self.actions:
            for _item_actions in self.actions:
                if _item_actions:
                    _items.append(_item_actions.to_dict())
            _dict['actions'] = _items
        # override the default output from pydantic by calling `to_dict()` of conditions
        if self.conditions:
            _dict['conditions'] = self.conditions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in var_from (list)
        _items = []
        if self.var_from:
            for _item_var_from in self.var_from:
                if _item_var_from:
                    _items.append(_item_var_from.to_dict())
            _dict['from'] = _items
        # override the default output from pydantic by calling `to_dict()` of to
        if self.to:
            _dict['to'] = self.to.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transition_screen
        if self.transition_screen:
            _dict['transitionScreen'] = self.transition_screen.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in triggers (list)
        _items = []
        if self.triggers:
            for _item_triggers in self.triggers:
                if _item_triggers:
                    _items.append(_item_triggers.to_dict())
            _dict['triggers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in validators (list)
        _items = []
        if self.validators:
            for _item_validators in self.validators:
                if _item_validators:
                    _items.append(_item_validators.to_dict())
            _dict['validators'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransitionPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "actions": [RulePayload.from_dict(_item) for _item in obj["actions"]] if obj.get("actions") is not None else None,
            "conditions": ConditionGroupPayload.from_dict(obj["conditions"]) if obj.get("conditions") is not None else None,
            "customIssueEventId": obj.get("customIssueEventId"),
            "description": obj.get("description"),
            "from": [FromLayoutPayload.from_dict(_item) for _item in obj["from"]] if obj.get("from") is not None else None,
            "id": obj.get("id"),
            "name": obj.get("name"),
            "properties": obj.get("properties"),
            "to": ToLayoutPayload.from_dict(obj["to"]) if obj.get("to") is not None else None,
            "transitionScreen": RulePayload.from_dict(obj["transitionScreen"]) if obj.get("transitionScreen") is not None else None,
            "triggers": [RulePayload.from_dict(_item) for _item in obj["triggers"]] if obj.get("triggers") is not None else None,
            "type": obj.get("type"),
            "validators": [RulePayload.from_dict(_item) for _item in obj["validators"]] if obj.get("validators") is not None else None
        })
        return _obj


