# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.condition_group_update import ConditionGroupUpdate
from devopso.clients.jira_cloud.models.workflow_rule_configuration import WorkflowRuleConfiguration
from devopso.clients.jira_cloud.models.workflow_transition_links import WorkflowTransitionLinks
from devopso.clients.jira_cloud.models.workflow_trigger import WorkflowTrigger
from typing import Optional, Set
from typing_extensions import Self

class TransitionUpdateDTO(BaseModel):
    """
    The transition update data.
    """ # noqa: E501
    actions: Optional[List[Optional[WorkflowRuleConfiguration]]] = Field(default=None, description="The post-functions of the transition.")
    conditions: Optional[ConditionGroupUpdate] = None
    custom_issue_event_id: Optional[StrictStr] = Field(default=None, description="The custom event ID of the transition.", alias="customIssueEventId")
    description: Optional[StrictStr] = Field(default=None, description="The description of the transition.")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the transition.")
    links: Optional[List[Optional[WorkflowTransitionLinks]]] = Field(default=None, description="The statuses the transition can start from, and the mapping of ports between the statuses.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the transition.")
    properties: Optional[Dict[str, StrictStr]] = Field(default=None, description="The properties of the transition.")
    to_status_reference: Optional[StrictStr] = Field(default=None, description="The status the transition goes to.", alias="toStatusReference")
    transition_screen: Optional[WorkflowRuleConfiguration] = Field(default=None, alias="transitionScreen")
    triggers: Optional[List[WorkflowTrigger]] = Field(default=None, description="The triggers of the transition.")
    type: Optional[StrictStr] = Field(default=None, description="The transition type.")
    validators: Optional[List[Optional[WorkflowRuleConfiguration]]] = Field(default=None, description="The validators of the transition.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["actions", "conditions", "customIssueEventId", "description", "id", "links", "name", "properties", "toStatusReference", "transitionScreen", "triggers", "type", "validators"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['INITIAL', 'GLOBAL', 'DIRECTED']):
            raise ValueError("must be one of enum values ('INITIAL', 'GLOBAL', 'DIRECTED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransitionUpdateDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in actions (list)
        _items = []
        if self.actions:
            for _item_actions in self.actions:
                if _item_actions:
                    _items.append(_item_actions.to_dict())
            _dict['actions'] = _items
        # override the default output from pydantic by calling `to_dict()` of conditions
        if self.conditions:
            _dict['conditions'] = self.conditions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of transition_screen
        if self.transition_screen:
            _dict['transitionScreen'] = self.transition_screen.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in triggers (list)
        _items = []
        if self.triggers:
            for _item_triggers in self.triggers:
                if _item_triggers:
                    _items.append(_item_triggers.to_dict())
            _dict['triggers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in validators (list)
        _items = []
        if self.validators:
            for _item_validators in self.validators:
                if _item_validators:
                    _items.append(_item_validators.to_dict())
            _dict['validators'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if conditions (nullable) is None
        # and model_fields_set contains the field
        if self.conditions is None and "conditions" in self.model_fields_set:
            _dict['conditions'] = None

        # set to None if transition_screen (nullable) is None
        # and model_fields_set contains the field
        if self.transition_screen is None and "transition_screen" in self.model_fields_set:
            _dict['transitionScreen'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransitionUpdateDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "actions": [WorkflowRuleConfiguration.from_dict(_item) for _item in obj["actions"]] if obj.get("actions") is not None else None,
            "conditions": ConditionGroupUpdate.from_dict(obj["conditions"]) if obj.get("conditions") is not None else None,
            "customIssueEventId": obj.get("customIssueEventId"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "links": [WorkflowTransitionLinks.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "name": obj.get("name"),
            "properties": obj.get("properties"),
            "toStatusReference": obj.get("toStatusReference"),
            "transitionScreen": WorkflowRuleConfiguration.from_dict(obj["transitionScreen"]) if obj.get("transitionScreen") is not None else None,
            "triggers": [WorkflowTrigger.from_dict(_item) for _item in obj["triggers"]] if obj.get("triggers") is not None else None,
            "type": obj.get("type"),
            "validators": [WorkflowRuleConfiguration.from_dict(_item) for _item in obj["validators"]] if obj.get("validators") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


