# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateCustomFieldDetails(BaseModel):
    """
    Details of a custom field.
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the custom field. The maximum length is 40000 characters.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the custom field. It doesn't have to be unique. The maximum length is 255 characters.")
    searcher_key: Optional[StrictStr] = Field(default=None, description="The searcher that defines the way the field is searched in Jira. It can be set to `null`, otherwise you must specify the valid searcher for the field type, as listed below (abbreviated values shown):   *  `cascadingselect`: `cascadingselectsearcher`  *  `datepicker`: `daterange`  *  `datetime`: `datetimerange`  *  `float`: `exactnumber` or `numberrange`  *  `grouppicker`: `grouppickersearcher`  *  `importid`: `exactnumber` or `numberrange`  *  `labels`: `labelsearcher`  *  `multicheckboxes`: `multiselectsearcher`  *  `multigrouppicker`: `multiselectsearcher`  *  `multiselect`: `multiselectsearcher`  *  `multiuserpicker`: `userpickergroupsearcher`  *  `multiversion`: `versionsearcher`  *  `project`: `projectsearcher`  *  `radiobuttons`: `multiselectsearcher`  *  `readonlyfield`: `textsearcher`  *  `select`: `multiselectsearcher`  *  `textarea`: `textsearcher`  *  `textfield`: `textsearcher`  *  `url`: `exacttextsearcher`  *  `userpicker`: `userpickergroupsearcher`  *  `version`: `versionsearcher`", alias="searcherKey")
    __properties: ClassVar[List[str]] = ["description", "name", "searcherKey"]

    @field_validator('searcher_key')
    def searcher_key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:daterange', 'com.atlassian.jira.plugin.system.customfieldtypes:datetimerange', 'com.atlassian.jira.plugin.system.customfieldtypes:exactnumber', 'com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:numberrange', 'com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:textsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher']):
            raise ValueError("must be one of enum values ('com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:daterange', 'com.atlassian.jira.plugin.system.customfieldtypes:datetimerange', 'com.atlassian.jira.plugin.system.customfieldtypes:exactnumber', 'com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:numberrange', 'com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:textsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher', 'com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateCustomFieldDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateCustomFieldDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "name": obj.get("name"),
            "searcherKey": obj.get("searcherKey")
        })
        return _obj


