# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class UpdatePriorityDetails(BaseModel):
    """
    Details of an issue priority.
    """ # noqa: E501
    avatar_id: Optional[StrictInt] = Field(default=None, description="The ID for the avatar for the priority. This parameter is nullable and both iconUrl and avatarId cannot be defined.", alias="avatarId")
    description: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The description of the priority.")
    icon_url: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used. Both iconUrl and avatarId cannot be defined.", alias="iconUrl")
    name: Optional[Annotated[str, Field(strict=True, max_length=60)]] = Field(default=None, description="The name of the priority. Must be unique.")
    status_color: Optional[StrictStr] = Field(default=None, description="The status color of the priority in 3-digit or 6-digit hexadecimal format.", alias="statusColor")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["avatarId", "description", "iconUrl", "name", "statusColor"]

    @field_validator('icon_url')
    def icon_url_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['/images/icons/priorities/blocker.png', '/images/icons/priorities/critical.png', '/images/icons/priorities/high.png', '/images/icons/priorities/highest.png', '/images/icons/priorities/low.png', '/images/icons/priorities/lowest.png', '/images/icons/priorities/major.png', '/images/icons/priorities/medium.png', '/images/icons/priorities/minor.png', '/images/icons/priorities/trivial.png', '/images/icons/priorities/blocker_new.png', '/images/icons/priorities/critical_new.png', '/images/icons/priorities/high_new.png', '/images/icons/priorities/highest_new.png', '/images/icons/priorities/low_new.png', '/images/icons/priorities/lowest_new.png', '/images/icons/priorities/major_new.png', '/images/icons/priorities/medium_new.png', '/images/icons/priorities/minor_new.png', '/images/icons/priorities/trivial_new.png']):
            raise ValueError("must be one of enum values ('/images/icons/priorities/blocker.png', '/images/icons/priorities/critical.png', '/images/icons/priorities/high.png', '/images/icons/priorities/highest.png', '/images/icons/priorities/low.png', '/images/icons/priorities/lowest.png', '/images/icons/priorities/major.png', '/images/icons/priorities/medium.png', '/images/icons/priorities/minor.png', '/images/icons/priorities/trivial.png', '/images/icons/priorities/blocker_new.png', '/images/icons/priorities/critical_new.png', '/images/icons/priorities/high_new.png', '/images/icons/priorities/highest_new.png', '/images/icons/priorities/low_new.png', '/images/icons/priorities/lowest_new.png', '/images/icons/priorities/major_new.png', '/images/icons/priorities/medium_new.png', '/images/icons/priorities/minor_new.png', '/images/icons/priorities/trivial_new.png')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdatePriorityDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if icon_url (nullable) is None
        # and model_fields_set contains the field
        if self.icon_url is None and "icon_url" in self.model_fields_set:
            _dict['iconUrl'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if status_color (nullable) is None
        # and model_fields_set contains the field
        if self.status_color is None and "status_color" in self.model_fields_set:
            _dict['statusColor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdatePriorityDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avatarId": obj.get("avatarId"),
            "description": obj.get("description"),
            "iconUrl": obj.get("iconUrl"),
            "name": obj.get("name"),
            "statusColor": obj.get("statusColor")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


