# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud.models.priority_mapping import PriorityMapping
from devopso.clients.jira_cloud.models.update_priorities_in_scheme_request_bean import UpdatePrioritiesInSchemeRequestBean
from devopso.clients.jira_cloud.models.update_projects_in_scheme_request_bean import UpdateProjectsInSchemeRequestBean
from typing import Optional, Set
from typing_extensions import Self

class UpdatePrioritySchemeRequestBean(BaseModel):
    """
    Details of a priority scheme.
    """ # noqa: E501
    default_priority_id: Optional[StrictInt] = Field(default=None, description="The default priority of the scheme.", alias="defaultPriorityId")
    description: Optional[Annotated[str, Field(strict=True, max_length=4000)]] = Field(default=None, description="The description of the priority scheme.")
    mappings: Optional[PriorityMapping] = Field(default=None, description="Instructions to migrate the priorities of issues.  `in` mappings are used to migrate the priorities of issues to priorities used within the priority scheme.  `out` mappings are used to migrate the priorities of issues to priorities not used within the priority scheme.   *  When **priorities** are **added** to the priority scheme, no mapping needs to be provided as the new priorities are not used by any issues.  *  When **priorities** are **removed** from the priority scheme, issues that are using those priorities must be migrated to new priorities used by the priority scheme.           *  An `in` mapping must be provided for each of these priorities.  *  When **projects** are **added** to the priority scheme, the priorities of issues in those projects might need to be migrated to new priorities used by the priority scheme. This can occur when the current scheme does not use all the priorities in the project(s)' priority scheme(s).           *  An `in` mapping must be provided for each of these priorities.  *  When **projects** are **removed** from the priority scheme, the priorities of issues in those projects might need to be migrated to new priorities within the **Default Priority Scheme** that are not used by the priority scheme. This can occur when the **Default Priority Scheme** does not use all the priorities within the current scheme.           *  An `out` mapping must be provided for each of these priorities.  For more information on `in` and `out` mappings, see the child properties documentation for the `PriorityMapping` object below.")
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The name of the priority scheme. Must be unique.")
    priorities: Optional[UpdatePrioritiesInSchemeRequestBean] = Field(default=None, description="The priorities in the scheme.")
    projects: Optional[UpdateProjectsInSchemeRequestBean] = Field(default=None, description="The projects in the scheme.")
    __properties: ClassVar[List[str]] = ["defaultPriorityId", "description", "mappings", "name", "priorities", "projects"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdatePrioritySchemeRequestBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mappings
        if self.mappings:
            _dict['mappings'] = self.mappings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of priorities
        if self.priorities:
            _dict['priorities'] = self.priorities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of projects
        if self.projects:
            _dict['projects'] = self.projects.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdatePrioritySchemeRequestBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultPriorityId": obj.get("defaultPriorityId"),
            "description": obj.get("description"),
            "mappings": PriorityMapping.from_dict(obj["mappings"]) if obj.get("mappings") is not None else None,
            "name": obj.get("name"),
            "priorities": UpdatePrioritiesInSchemeRequestBean.from_dict(obj["priorities"]) if obj.get("priorities") is not None else None,
            "projects": UpdateProjectsInSchemeRequestBean.from_dict(obj["projects"]) if obj.get("projects") is not None else None
        })
        return _obj


