# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class UpdateProjectDetails(BaseModel):
    """
    Details about the project.
    """ # noqa: E501
    assignee_type: Optional[StrictStr] = Field(default=None, description="The default assignee when creating issues for this project.", alias="assigneeType")
    avatar_id: Optional[StrictInt] = Field(default=None, description="An integer value for the project's avatar.", alias="avatarId")
    category_id: Optional[StrictInt] = Field(default=None, description="The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation. To remove the project category from the project, set the value to `-1.`", alias="categoryId")
    description: Optional[StrictStr] = Field(default=None, description="A brief description of the project.")
    issue_security_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) resource to get all issue security scheme IDs.", alias="issueSecurityScheme")
    key: Optional[StrictStr] = Field(default=None, description="Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.")
    lead: Optional[StrictStr] = Field(default=None, description="This parameter is deprecated because of privacy changes. Use `leadAccountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Cannot be provided with `leadAccountId`.")
    lead_account_id: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="The account ID of the project lead. Cannot be provided with `lead`.", alias="leadAccountId")
    name: Optional[StrictStr] = Field(default=None, description="The name of the project.")
    notification_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-3-notificationscheme-get) resource to get a list of notification scheme IDs.", alias="notificationScheme")
    permission_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to see a list of all permission scheme IDs.", alias="permissionScheme")
    released_project_keys: Optional[List[StrictStr]] = Field(default=None, description="Previous project keys to be released from the current project. Released keys must belong to the current project and not contain the current project key", alias="releasedProjectKeys")
    url: Optional[StrictStr] = Field(default=None, description="A link to information about this project, such as project documentation")
    __properties: ClassVar[List[str]] = ["assigneeType", "avatarId", "categoryId", "description", "issueSecurityScheme", "key", "lead", "leadAccountId", "name", "notificationScheme", "permissionScheme", "releasedProjectKeys", "url"]

    @field_validator('assignee_type')
    def assignee_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PROJECT_LEAD', 'UNASSIGNED']):
            raise ValueError("must be one of enum values ('PROJECT_LEAD', 'UNASSIGNED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateProjectDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateProjectDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assigneeType": obj.get("assigneeType"),
            "avatarId": obj.get("avatarId"),
            "categoryId": obj.get("categoryId"),
            "description": obj.get("description"),
            "issueSecurityScheme": obj.get("issueSecurityScheme"),
            "key": obj.get("key"),
            "lead": obj.get("lead"),
            "leadAccountId": obj.get("leadAccountId"),
            "name": obj.get("name"),
            "notificationScheme": obj.get("notificationScheme"),
            "permissionScheme": obj.get("permissionScheme"),
            "releasedProjectKeys": obj.get("releasedProjectKeys"),
            "url": obj.get("url")
        })
        return _obj


