# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud.models.avatar_urls_bean import AvatarUrlsBean
from devopso.clients.jira_cloud.models.simple_list_wrapper_application_role import SimpleListWrapperApplicationRole
from devopso.clients.jira_cloud.models.simple_list_wrapper_group_name import SimpleListWrapperGroupName
from typing import Optional, Set
from typing_extensions import Self

class User(BaseModel):
    """
    A user with details as permitted by the user's Atlassian Account privacy settings. However, be aware of these exceptions:   *  User record deleted from Atlassian: This occurs as the result of a right to be forgotten request. In this case, `displayName` provides an indication and other parameters have default values or are blank (for example, email is blank).  *  User record corrupted: This occurs as a results of events such as a server import and can only happen to deleted users. In this case, `accountId` returns *unknown* and all other parameters have fallback values.  *  User record unavailable: This usually occurs due to an internal service outage. In this case, all parameters have fallback values.
    """ # noqa: E501
    account_id: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Required in requests.", alias="accountId")
    account_type: Optional[StrictStr] = Field(default=None, description="The user account type. Can take the following values:   *  `atlassian` regular Atlassian user account  *  `app` system account used for Connect applications and OAuth to represent external systems  *  `customer` Jira Service Desk account representing an external service desk", alias="accountType")
    active: Optional[StrictBool] = Field(default=None, description="Whether the user is active.")
    application_roles: Optional[SimpleListWrapperApplicationRole] = Field(default=None, description="The application roles the user is assigned to.", alias="applicationRoles")
    avatar_urls: Optional[AvatarUrlsBean] = Field(default=None, description="The avatars of the user.", alias="avatarUrls")
    display_name: Optional[StrictStr] = Field(default=None, description="The display name of the user. Depending on the user’s privacy setting, this may return an alternative value.", alias="displayName")
    email_address: Optional[StrictStr] = Field(default=None, description="The email address of the user. Depending on the user’s privacy setting, this may be returned as null.", alias="emailAddress")
    expand: Optional[StrictStr] = Field(default=None, description="Expand options that include additional user details in the response.")
    groups: Optional[SimpleListWrapperGroupName] = Field(default=None, description="The groups that the user belongs to.")
    key: Optional[StrictStr] = Field(default=None, description="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    locale: Optional[StrictStr] = Field(default=None, description="The locale of the user. Depending on the user’s privacy setting, this may be returned as null.")
    name: Optional[StrictStr] = Field(default=None, description="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the user.", alias="self")
    time_zone: Optional[StrictStr] = Field(default=None, description="The time zone specified in the user's profile. If the user's time zone is not visible to the current user (due to user's profile setting), or if a time zone has not been set, the instance's default time zone will be returned.", alias="timeZone")
    __properties: ClassVar[List[str]] = ["accountId", "accountType", "active", "applicationRoles", "avatarUrls", "displayName", "emailAddress", "expand", "groups", "key", "locale", "name", "self", "timeZone"]

    @field_validator('account_type')
    def account_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['atlassian', 'app', 'customer', 'unknown']):
            raise ValueError("must be one of enum values ('atlassian', 'app', 'customer', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "account_type",
            "active",
            "application_roles",
            "avatar_urls",
            "display_name",
            "email_address",
            "expand",
            "groups",
            "locale",
            "var_self",
            "time_zone",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of application_roles
        if self.application_roles:
            _dict['applicationRoles'] = self.application_roles.to_dict()
        # override the default output from pydantic by calling `to_dict()` of avatar_urls
        if self.avatar_urls:
            _dict['avatarUrls'] = self.avatar_urls.to_dict()
        # override the default output from pydantic by calling `to_dict()` of groups
        if self.groups:
            _dict['groups'] = self.groups.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "accountType": obj.get("accountType"),
            "active": obj.get("active"),
            "applicationRoles": SimpleListWrapperApplicationRole.from_dict(obj["applicationRoles"]) if obj.get("applicationRoles") is not None else None,
            "avatarUrls": AvatarUrlsBean.from_dict(obj["avatarUrls"]) if obj.get("avatarUrls") is not None else None,
            "displayName": obj.get("displayName"),
            "emailAddress": obj.get("emailAddress"),
            "expand": obj.get("expand"),
            "groups": SimpleListWrapperGroupName.from_dict(obj["groups"]) if obj.get("groups") is not None else None,
            "key": obj.get("key"),
            "locale": obj.get("locale"),
            "name": obj.get("name"),
            "self": obj.get("self"),
            "timeZone": obj.get("timeZone")
        })
        return _obj


