# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud.models.avatar_urls_bean import AvatarUrlsBean
from typing import Optional, Set
from typing_extensions import Self

class UserDetails(BaseModel):
    """
    User details permitted by the user's Atlassian Account privacy settings. However, be aware of these exceptions:   *  User record deleted from Atlassian: This occurs as the result of a right to be forgotten request. In this case, `displayName` provides an indication and other parameters have default values or are blank (for example, email is blank).  *  User record corrupted: This occurs as a results of events such as a server import and can only happen to deleted users. In this case, `accountId` returns *unknown* and all other parameters have fallback values.  *  User record unavailable: This usually occurs due to an internal service outage. In this case, all parameters have fallback values.
    """ # noqa: E501
    account_id: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.", alias="accountId")
    account_type: Optional[StrictStr] = Field(default=None, description="The type of account represented by this user. This will be one of 'atlassian' (normal users), 'app' (application user) or 'customer' (Jira Service Desk customer user)", alias="accountType")
    active: Optional[StrictBool] = Field(default=None, description="Whether the user is active.")
    avatar_urls: Optional[AvatarUrlsBean] = Field(default=None, description="The avatars of the user.", alias="avatarUrls")
    display_name: Optional[StrictStr] = Field(default=None, description="The display name of the user. Depending on the user’s privacy settings, this may return an alternative value.", alias="displayName")
    email_address: Optional[StrictStr] = Field(default=None, description="The email address of the user. Depending on the user’s privacy settings, this may be returned as null.", alias="emailAddress")
    key: Optional[StrictStr] = Field(default=None, description="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    name: Optional[StrictStr] = Field(default=None, description="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the user.", alias="self")
    time_zone: Optional[StrictStr] = Field(default=None, description="The time zone specified in the user's profile. Depending on the user’s privacy settings, this may be returned as null.", alias="timeZone")
    __properties: ClassVar[List[str]] = ["accountId", "accountType", "active", "avatarUrls", "displayName", "emailAddress", "key", "name", "self", "timeZone"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "account_type",
            "active",
            "avatar_urls",
            "display_name",
            "email_address",
            "key",
            "name",
            "var_self",
            "time_zone",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of avatar_urls
        if self.avatar_urls:
            _dict['avatarUrls'] = self.avatar_urls.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "accountType": obj.get("accountType"),
            "active": obj.get("active"),
            "avatarUrls": AvatarUrlsBean.from_dict(obj["avatarUrls"]) if obj.get("avatarUrls") is not None else None,
            "displayName": obj.get("displayName"),
            "emailAddress": obj.get("emailAddress"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "self": obj.get("self"),
            "timeZone": obj.get("timeZone")
        })
        return _obj


