# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserPickerUser(BaseModel):
    """
    A user found in a search.
    """ # noqa: E501
    account_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.", alias="accountId")
    account_type: Optional[StrictStr] = Field(default=None, description="The user account type. Can take the following values:   *  `atlassian` regular Atlassian user account  *  `app` system account used for Connect applications and OAuth to represent external systems  *  `customer` Jira Service Desk account representing an external service desk", alias="accountType")
    avatar_url: Optional[StrictStr] = Field(default=None, description="The avatar URL of the user.", alias="avatarUrl")
    display_name: Optional[StrictStr] = Field(default=None, description="The display name of the user. Depending on the user’s privacy setting, this may be returned as null.", alias="displayName")
    html: Optional[StrictStr] = Field(default=None, description="The display name, email address, and key of the user with the matched query string highlighted with the HTML bold tag.")
    key: Optional[StrictStr] = Field(default=None, description="This property is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    name: Optional[StrictStr] = Field(default=None, description="This property is no longer available . See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    __properties: ClassVar[List[str]] = ["accountId", "accountType", "avatarUrl", "displayName", "html", "key", "name"]

    @field_validator('account_type')
    def account_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['atlassian', 'app', 'customer', 'unknown']):
            raise ValueError("must be one of enum values ('atlassian', 'app', 'customer', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserPickerUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserPickerUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "accountType": obj.get("accountType"),
            "avatarUrl": obj.get("avatarUrl"),
            "displayName": obj.get("displayName"),
            "html": obj.get("html"),
            "key": obj.get("key"),
            "name": obj.get("name")
        })
        return _obj


