# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.version_usage_in_custom_field import VersionUsageInCustomField
from typing import Optional, Set
from typing_extensions import Self

class VersionIssueCounts(BaseModel):
    """
    Various counts of issues within a version.
    """ # noqa: E501
    custom_field_usage: Optional[List[VersionUsageInCustomField]] = Field(default=None, description="List of custom fields using the version.", alias="customFieldUsage")
    issue_count_with_custom_fields_showing_version: Optional[StrictInt] = Field(default=None, description="Count of issues where a version custom field is set to the version.", alias="issueCountWithCustomFieldsShowingVersion")
    issues_affected_count: Optional[StrictInt] = Field(default=None, description="Count of issues where the `affectedVersion` is set to the version.", alias="issuesAffectedCount")
    issues_fixed_count: Optional[StrictInt] = Field(default=None, description="Count of issues where the `fixVersion` is set to the version.", alias="issuesFixedCount")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of these count details.", alias="self")
    __properties: ClassVar[List[str]] = ["customFieldUsage", "issueCountWithCustomFieldsShowingVersion", "issuesAffectedCount", "issuesFixedCount", "self"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VersionIssueCounts from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "custom_field_usage",
            "issue_count_with_custom_fields_showing_version",
            "issues_affected_count",
            "issues_fixed_count",
            "var_self",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_field_usage (list)
        _items = []
        if self.custom_field_usage:
            for _item_custom_field_usage in self.custom_field_usage:
                if _item_custom_field_usage:
                    _items.append(_item_custom_field_usage.to_dict())
            _dict['customFieldUsage'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VersionIssueCounts from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customFieldUsage": [VersionUsageInCustomField.from_dict(_item) for _item in obj["customFieldUsage"]] if obj.get("customFieldUsage") is not None else None,
            "issueCountWithCustomFieldsShowingVersion": obj.get("issueCountWithCustomFieldsShowingVersion"),
            "issuesAffectedCount": obj.get("issuesAffectedCount"),
            "issuesFixedCount": obj.get("issuesFixedCount"),
            "self": obj.get("self")
        })
        return _obj


