# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class VersionRelatedWork(BaseModel):
    """
    Associated related work to a version
    """ # noqa: E501
    category: StrictStr = Field(description="The category of the related work")
    issue_id: Optional[StrictInt] = Field(default=None, description="The ID of the issue associated with the related work (if there is one). Cannot be updated via the Rest API.", alias="issueId")
    related_work_id: Optional[StrictStr] = Field(default=None, description="The id of the related work. For the native release note related work item, this will be null, and Rest API does not support updating it.", alias="relatedWorkId")
    title: Optional[StrictStr] = Field(default=None, description="The title of the related work")
    url: Optional[StrictStr] = Field(default=None, description="The URL of the related work. Will be null for the native release note related work item, but is otherwise required.")
    __properties: ClassVar[List[str]] = ["category", "issueId", "relatedWorkId", "title", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VersionRelatedWork from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "issue_id",
            "related_work_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VersionRelatedWork from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "category": obj.get("category"),
            "issueId": obj.get("issueId"),
            "relatedWorkId": obj.get("relatedWorkId"),
            "title": obj.get("title"),
            "url": obj.get("url")
        })
        return _obj


