# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.user_details import UserDetails
from typing import Optional, Set
from typing_extensions import Self

class Watchers(BaseModel):
    """
    The details of watchers on an issue.
    """ # noqa: E501
    is_watching: Optional[StrictBool] = Field(default=None, description="Whether the calling user is watching this issue.", alias="isWatching")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of these issue watcher details.", alias="self")
    watch_count: Optional[StrictInt] = Field(default=None, description="The number of users watching this issue.", alias="watchCount")
    watchers: Optional[List[UserDetails]] = Field(default=None, description="Details of the users watching this issue.")
    __properties: ClassVar[List[str]] = ["isWatching", "self", "watchCount", "watchers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Watchers from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_watching",
            "var_self",
            "watch_count",
            "watchers",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in watchers (list)
        _items = []
        if self.watchers:
            for _item_watchers in self.watchers:
                if _item_watchers:
                    _items.append(_item_watchers.to_dict())
            _dict['watchers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Watchers from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isWatching": obj.get("isWatching"),
            "self": obj.get("self"),
            "watchCount": obj.get("watchCount"),
            "watchers": [UserDetails.from_dict(_item) for _item in obj["watchers"]] if obj.get("watchers") is not None else None
        })
        return _obj


