# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_details import ProjectDetails
from devopso.clients.jira_cloud.models.published_workflow_id import PublishedWorkflowId
from devopso.clients.jira_cloud.models.transition import Transition
from devopso.clients.jira_cloud.models.workflow_operations import WorkflowOperations
from devopso.clients.jira_cloud.models.workflow_scheme_id_name import WorkflowSchemeIdName
from devopso.clients.jira_cloud.models.workflow_status import WorkflowStatus
from typing import Optional, Set
from typing_extensions import Self

class Workflow(BaseModel):
    """
    Details about a workflow.
    """ # noqa: E501
    created: Optional[datetime] = Field(default=None, description="The creation date of the workflow.")
    description: StrictStr = Field(description="The description of the workflow.")
    has_draft_workflow: Optional[StrictBool] = Field(default=None, description="Whether the workflow has a draft version.", alias="hasDraftWorkflow")
    id: PublishedWorkflowId
    is_default: Optional[StrictBool] = Field(default=None, description="Whether this is the default workflow.", alias="isDefault")
    operations: Optional[WorkflowOperations] = None
    projects: Optional[List[ProjectDetails]] = Field(default=None, description="The projects the workflow is assigned to, through workflow schemes.")
    schemes: Optional[List[WorkflowSchemeIdName]] = Field(default=None, description="The workflow schemes the workflow is assigned to.")
    statuses: Optional[List[WorkflowStatus]] = Field(default=None, description="The statuses of the workflow.")
    transitions: Optional[List[Transition]] = Field(default=None, description="The transitions of the workflow.")
    updated: Optional[datetime] = Field(default=None, description="The last edited date of the workflow.")
    __properties: ClassVar[List[str]] = ["created", "description", "hasDraftWorkflow", "id", "isDefault", "operations", "projects", "schemes", "statuses", "transitions", "updated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Workflow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operations
        if self.operations:
            _dict['operations'] = self.operations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item_projects in self.projects:
                if _item_projects:
                    _items.append(_item_projects.to_dict())
            _dict['projects'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in schemes (list)
        _items = []
        if self.schemes:
            for _item_schemes in self.schemes:
                if _item_schemes:
                    _items.append(_item_schemes.to_dict())
            _dict['schemes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in statuses (list)
        _items = []
        if self.statuses:
            for _item_statuses in self.statuses:
                if _item_statuses:
                    _items.append(_item_statuses.to_dict())
            _dict['statuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transitions (list)
        _items = []
        if self.transitions:
            for _item_transitions in self.transitions:
                if _item_transitions:
                    _items.append(_item_transitions.to_dict())
            _dict['transitions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Workflow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created": obj.get("created"),
            "description": obj.get("description"),
            "hasDraftWorkflow": obj.get("hasDraftWorkflow"),
            "id": PublishedWorkflowId.from_dict(obj["id"]) if obj.get("id") is not None else None,
            "isDefault": obj.get("isDefault"),
            "operations": WorkflowOperations.from_dict(obj["operations"]) if obj.get("operations") is not None else None,
            "projects": [ProjectDetails.from_dict(_item) for _item in obj["projects"]] if obj.get("projects") is not None else None,
            "schemes": [WorkflowSchemeIdName.from_dict(_item) for _item in obj["schemes"]] if obj.get("schemes") is not None else None,
            "statuses": [WorkflowStatus.from_dict(_item) for _item in obj["statuses"]] if obj.get("statuses") is not None else None,
            "transitions": [Transition.from_dict(_item) for _item in obj["transitions"]] if obj.get("transitions") is not None else None,
            "updated": obj.get("updated")
        })
        return _obj


