# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.available_workflow_connect_rule import AvailableWorkflowConnectRule
from devopso.clients.jira_cloud.models.available_workflow_forge_rule import AvailableWorkflowForgeRule
from devopso.clients.jira_cloud.models.available_workflow_system_rule import AvailableWorkflowSystemRule
from devopso.clients.jira_cloud.models.available_workflow_triggers import AvailableWorkflowTriggers
from typing import Optional, Set
from typing_extensions import Self

class WorkflowCapabilities(BaseModel):
    """
    WorkflowCapabilities
    """ # noqa: E501
    connect_rules: Optional[List[AvailableWorkflowConnectRule]] = Field(default=None, description="The Connect provided ecosystem rules available.", alias="connectRules")
    editor_scope: Optional[StrictStr] = Field(default=None, description="The scope of the workflow capabilities. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.", alias="editorScope")
    forge_rules: Optional[List[AvailableWorkflowForgeRule]] = Field(default=None, description="The Forge provided ecosystem rules available.", alias="forgeRules")
    project_types: Optional[List[StrictStr]] = Field(default=None, description="The types of projects that this capability set is available for.", alias="projectTypes")
    system_rules: Optional[List[AvailableWorkflowSystemRule]] = Field(default=None, description="The Atlassian provided system rules available.", alias="systemRules")
    trigger_rules: Optional[List[AvailableWorkflowTriggers]] = Field(default=None, description="The trigger rules available.", alias="triggerRules")
    __properties: ClassVar[List[str]] = ["connectRules", "editorScope", "forgeRules", "projectTypes", "systemRules", "triggerRules"]

    @field_validator('editor_scope')
    def editor_scope_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PROJECT', 'GLOBAL']):
            raise ValueError("must be one of enum values ('PROJECT', 'GLOBAL')")
        return value

    @field_validator('project_types')
    def project_types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['software', 'service_desk', 'product_discovery', 'business', 'unknown']):
                raise ValueError("each list item must be one of ('software', 'service_desk', 'product_discovery', 'business', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowCapabilities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in connect_rules (list)
        _items = []
        if self.connect_rules:
            for _item_connect_rules in self.connect_rules:
                if _item_connect_rules:
                    _items.append(_item_connect_rules.to_dict())
            _dict['connectRules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in forge_rules (list)
        _items = []
        if self.forge_rules:
            for _item_forge_rules in self.forge_rules:
                if _item_forge_rules:
                    _items.append(_item_forge_rules.to_dict())
            _dict['forgeRules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in system_rules (list)
        _items = []
        if self.system_rules:
            for _item_system_rules in self.system_rules:
                if _item_system_rules:
                    _items.append(_item_system_rules.to_dict())
            _dict['systemRules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in trigger_rules (list)
        _items = []
        if self.trigger_rules:
            for _item_trigger_rules in self.trigger_rules:
                if _item_trigger_rules:
                    _items.append(_item_trigger_rules.to_dict())
            _dict['triggerRules'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowCapabilities from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "connectRules": [AvailableWorkflowConnectRule.from_dict(_item) for _item in obj["connectRules"]] if obj.get("connectRules") is not None else None,
            "editorScope": obj.get("editorScope"),
            "forgeRules": [AvailableWorkflowForgeRule.from_dict(_item) for _item in obj["forgeRules"]] if obj.get("forgeRules") is not None else None,
            "projectTypes": obj.get("projectTypes"),
            "systemRules": [AvailableWorkflowSystemRule.from_dict(_item) for _item in obj["systemRules"]] if obj.get("systemRules") is not None else None,
            "triggerRules": [AvailableWorkflowTriggers.from_dict(_item) for _item in obj["triggerRules"]] if obj.get("triggerRules") is not None else None
        })
        return _obj


