# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from devopso.clients.jira_cloud.models.workflow_simple_condition import WorkflowSimpleCondition
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

WORKFLOWCONDITION_ONE_OF_SCHEMAS = ["WorkflowCompoundCondition", "WorkflowSimpleCondition"]

class WorkflowCondition(BaseModel):
    """
    The workflow transition rule conditions tree.
    """
    # data type: WorkflowSimpleCondition
    oneof_schema_1_validator: Optional[WorkflowSimpleCondition] = None
    # data type: WorkflowCompoundCondition
    oneof_schema_2_validator: Optional[WorkflowCompoundCondition] = None
    actual_instance: Optional[Union[WorkflowCompoundCondition, WorkflowSimpleCondition]] = None
    one_of_schemas: Set[str] = { "WorkflowCompoundCondition", "WorkflowSimpleCondition" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = WorkflowCondition.model_construct()
        error_messages = []
        match = 0
        # validate data type: WorkflowSimpleCondition
        if not isinstance(v, WorkflowSimpleCondition):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WorkflowSimpleCondition`")
        else:
            match += 1
        # validate data type: WorkflowCompoundCondition
        if not isinstance(v, WorkflowCompoundCondition):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WorkflowCompoundCondition`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in WorkflowCondition with oneOf schemas: WorkflowCompoundCondition, WorkflowSimpleCondition. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in WorkflowCondition with oneOf schemas: WorkflowCompoundCondition, WorkflowSimpleCondition. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into WorkflowSimpleCondition
        try:
            instance.actual_instance = WorkflowSimpleCondition.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WorkflowCompoundCondition
        try:
            instance.actual_instance = WorkflowCompoundCondition.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into WorkflowCondition with oneOf schemas: WorkflowCompoundCondition, WorkflowSimpleCondition. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into WorkflowCondition with oneOf schemas: WorkflowCompoundCondition, WorkflowSimpleCondition. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], WorkflowCompoundCondition, WorkflowSimpleCondition]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())

from devopso.clients.jira_cloud.models.workflow_compound_condition import WorkflowCompoundCondition
# TODO: Rewrite to not use raise_errors
WorkflowCondition.model_rebuild(raise_errors=False)

