# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from devopso.clients.jira_cloud.models.transition_payload import TransitionPayload
from devopso.clients.jira_cloud.models.workflow_status_layout_payload import WorkflowStatusLayoutPayload
from devopso.clients.jira_cloud.models.workflow_status_payload import WorkflowStatusPayload
from typing import Optional, Set
from typing_extensions import Self

class WorkflowPayload(BaseModel):
    """
    The payload for creating workflow, see https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/\\#api-rest-api-3-workflows-create-post
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the workflow")
    looped_transition_container_layout: Optional[WorkflowStatusLayoutPayload] = Field(default=None, alias="loopedTransitionContainerLayout")
    name: Optional[StrictStr] = Field(default=None, description="The name of the workflow")
    on_conflict: Optional[StrictStr] = Field(default='NEW', description="The strategy to use if there is a conflict with another workflow", alias="onConflict")
    pcri: Optional[ProjectCreateResourceIdentifier] = None
    start_point_layout: Optional[WorkflowStatusLayoutPayload] = Field(default=None, alias="startPointLayout")
    statuses: Optional[List[WorkflowStatusPayload]] = Field(default=None, description="The statuses to be used in the workflow")
    transitions: Optional[List[TransitionPayload]] = Field(default=None, description="The transitions for the workflow")
    __properties: ClassVar[List[str]] = ["description", "loopedTransitionContainerLayout", "name", "onConflict", "pcri", "startPointLayout", "statuses", "transitions"]

    @field_validator('on_conflict')
    def on_conflict_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FAIL', 'USE', 'NEW']):
            raise ValueError("must be one of enum values ('FAIL', 'USE', 'NEW')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of looped_transition_container_layout
        if self.looped_transition_container_layout:
            _dict['loopedTransitionContainerLayout'] = self.looped_transition_container_layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pcri
        if self.pcri:
            _dict['pcri'] = self.pcri.to_dict()
        # override the default output from pydantic by calling `to_dict()` of start_point_layout
        if self.start_point_layout:
            _dict['startPointLayout'] = self.start_point_layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in statuses (list)
        _items = []
        if self.statuses:
            for _item_statuses in self.statuses:
                if _item_statuses:
                    _items.append(_item_statuses.to_dict())
            _dict['statuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transitions (list)
        _items = []
        if self.transitions:
            for _item_transitions in self.transitions:
                if _item_transitions:
                    _items.append(_item_transitions.to_dict())
            _dict['transitions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "loopedTransitionContainerLayout": WorkflowStatusLayoutPayload.from_dict(obj["loopedTransitionContainerLayout"]) if obj.get("loopedTransitionContainerLayout") is not None else None,
            "name": obj.get("name"),
            "onConflict": obj.get("onConflict") if obj.get("onConflict") is not None else 'NEW',
            "pcri": ProjectCreateResourceIdentifier.from_dict(obj["pcri"]) if obj.get("pcri") is not None else None,
            "startPointLayout": WorkflowStatusLayoutPayload.from_dict(obj["startPointLayout"]) if obj.get("startPointLayout") is not None else None,
            "statuses": [WorkflowStatusPayload.from_dict(_item) for _item in obj["statuses"]] if obj.get("statuses") is not None else None,
            "transitions": [TransitionPayload.from_dict(_item) for _item in obj["transitions"]] if obj.get("transitions") is not None else None
        })
        return _obj


