# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.approval_configuration_preview import ApprovalConfigurationPreview
from devopso.clients.jira_cloud.models.workflow_preview_layout import WorkflowPreviewLayout
from typing import Optional, Set
from typing_extensions import Self

class WorkflowPreviewStatus(BaseModel):
    """
    Details about a workflow status in preview context.
    """ # noqa: E501
    approval_configuration: Optional[ApprovalConfigurationPreview] = Field(default=None, alias="approvalConfiguration")
    deprecated: Optional[StrictBool] = Field(default=None, description="Whether the status is deprecated.")
    layout: Optional[WorkflowPreviewLayout] = None
    status_reference: Optional[StrictStr] = Field(default=None, description="The reference of the status.", alias="statusReference")
    __properties: ClassVar[List[str]] = ["approvalConfiguration", "deprecated", "layout", "statusReference"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowPreviewStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of approval_configuration
        if self.approval_configuration:
            _dict['approvalConfiguration'] = self.approval_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of layout
        if self.layout:
            _dict['layout'] = self.layout.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowPreviewStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "approvalConfiguration": ApprovalConfigurationPreview.from_dict(obj["approvalConfiguration"]) if obj.get("approvalConfiguration") is not None else None,
            "deprecated": obj.get("deprecated"),
            "layout": WorkflowPreviewLayout.from_dict(obj["layout"]) if obj.get("layout") is not None else None,
            "statusReference": obj.get("statusReference")
        })
        return _obj


