# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.approval_configuration import ApprovalConfiguration
from devopso.clients.jira_cloud.models.workflow_status_layout import WorkflowStatusLayout
from typing import Optional, Set
from typing_extensions import Self

class WorkflowReferenceStatus(BaseModel):
    """
    The statuses referenced in the workflow.
    """ # noqa: E501
    approval_configuration: Optional[ApprovalConfiguration] = Field(default=None, alias="approvalConfiguration")
    deprecated: Optional[StrictBool] = Field(default=None, description="Indicates if the status is deprecated.")
    layout: Optional[WorkflowStatusLayout] = None
    properties: Optional[Dict[str, StrictStr]] = Field(default=None, description="The properties associated with the status.")
    status_reference: Optional[StrictStr] = Field(default=None, description="The reference of the status.", alias="statusReference")
    __properties: ClassVar[List[str]] = ["approvalConfiguration", "deprecated", "layout", "properties", "statusReference"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowReferenceStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of approval_configuration
        if self.approval_configuration:
            _dict['approvalConfiguration'] = self.approval_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of layout
        if self.layout:
            _dict['layout'] = self.layout.to_dict()
        # set to None if approval_configuration (nullable) is None
        # and model_fields_set contains the field
        if self.approval_configuration is None and "approval_configuration" in self.model_fields_set:
            _dict['approvalConfiguration'] = None

        # set to None if layout (nullable) is None
        # and model_fields_set contains the field
        if self.layout is None and "layout" in self.model_fields_set:
            _dict['layout'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowReferenceStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "approvalConfiguration": ApprovalConfiguration.from_dict(obj["approvalConfiguration"]) if obj.get("approvalConfiguration") is not None else None,
            "deprecated": obj.get("deprecated"),
            "layout": WorkflowStatusLayout.from_dict(obj["layout"]) if obj.get("layout") is not None else None,
            "properties": obj.get("properties"),
            "statusReference": obj.get("statusReference")
        })
        return _obj


