# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.issue_type_details import IssueTypeDetails
from devopso.clients.jira_cloud.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class WorkflowScheme(BaseModel):
    """
    Details about a workflow scheme.
    """ # noqa: E501
    default_workflow: Optional[StrictStr] = Field(default=None, description="The name of the default workflow for the workflow scheme. The default workflow has *All Unassigned Issue Types* assigned to it in Jira. If `defaultWorkflow` is not specified when creating a workflow scheme, it is set to *Jira Workflow (jira)*.", alias="defaultWorkflow")
    description: Optional[StrictStr] = Field(default=None, description="The description of the workflow scheme.")
    draft: Optional[StrictBool] = Field(default=None, description="Whether the workflow scheme is a draft or not.")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the workflow scheme.")
    issue_type_mappings: Optional[Dict[str, StrictStr]] = Field(default=None, description="The issue type to workflow mappings, where each mapping is an issue type ID and workflow name pair. Note that an issue type can only be mapped to one workflow in a workflow scheme.", alias="issueTypeMappings")
    issue_types: Optional[Dict[str, IssueTypeDetails]] = Field(default=None, description="The issue types available in Jira.", alias="issueTypes")
    last_modified: Optional[StrictStr] = Field(default=None, description="The date-time that the draft workflow scheme was last modified. A modification is a change to the issue type-project mappings only. This property does not apply to non-draft workflows.", alias="lastModified")
    last_modified_user: Optional[User] = Field(default=None, description="The user that last modified the draft workflow scheme. A modification is a change to the issue type-project mappings only. This property does not apply to non-draft workflows.", alias="lastModifiedUser")
    name: Optional[StrictStr] = Field(default=None, description="The name of the workflow scheme. The name must be unique. The maximum length is 255 characters. Required when creating a workflow scheme.")
    original_default_workflow: Optional[StrictStr] = Field(default=None, description="For draft workflow schemes, this property is the name of the default workflow for the original workflow scheme. The default workflow has *All Unassigned Issue Types* assigned to it in Jira.", alias="originalDefaultWorkflow")
    original_issue_type_mappings: Optional[Dict[str, StrictStr]] = Field(default=None, description="For draft workflow schemes, this property is the issue type to workflow mappings for the original workflow scheme, where each mapping is an issue type ID and workflow name pair. Note that an issue type can only be mapped to one workflow in a workflow scheme.", alias="originalIssueTypeMappings")
    var_self: Optional[StrictStr] = Field(default=None, alias="self")
    update_draft_if_needed: Optional[StrictBool] = Field(default=None, description="Whether to create or update a draft workflow scheme when updating an active workflow scheme. An active workflow scheme is a workflow scheme that is used by at least one project. The following examples show how this property works:   *  Update an active workflow scheme with `updateDraftIfNeeded` set to `true`: If a draft workflow scheme exists, it is updated. Otherwise, a draft workflow scheme is created.  *  Update an active workflow scheme with `updateDraftIfNeeded` set to `false`: An error is returned, as active workflow schemes cannot be updated.  *  Update an inactive workflow scheme with `updateDraftIfNeeded` set to `true`: The workflow scheme is updated, as inactive workflow schemes do not require drafts to update.  Defaults to `false`.", alias="updateDraftIfNeeded")
    __properties: ClassVar[List[str]] = ["defaultWorkflow", "description", "draft", "id", "issueTypeMappings", "issueTypes", "lastModified", "lastModifiedUser", "name", "originalDefaultWorkflow", "originalIssueTypeMappings", "self", "updateDraftIfNeeded"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowScheme from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "draft",
            "id",
            "issue_types",
            "last_modified",
            "last_modified_user",
            "original_default_workflow",
            "original_issue_type_mappings",
            "var_self",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in issue_types (dict)
        _field_dict = {}
        if self.issue_types:
            for _key_issue_types in self.issue_types:
                if self.issue_types[_key_issue_types]:
                    _field_dict[_key_issue_types] = self.issue_types[_key_issue_types].to_dict()
            _dict['issueTypes'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of last_modified_user
        if self.last_modified_user:
            _dict['lastModifiedUser'] = self.last_modified_user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowScheme from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultWorkflow": obj.get("defaultWorkflow"),
            "description": obj.get("description"),
            "draft": obj.get("draft"),
            "id": obj.get("id"),
            "issueTypeMappings": obj.get("issueTypeMappings"),
            "issueTypes": dict(
                (_k, IssueTypeDetails.from_dict(_v))
                for _k, _v in obj["issueTypes"].items()
            )
            if obj.get("issueTypes") is not None
            else None,
            "lastModified": obj.get("lastModified"),
            "lastModifiedUser": User.from_dict(obj["lastModifiedUser"]) if obj.get("lastModifiedUser") is not None else None,
            "name": obj.get("name"),
            "originalDefaultWorkflow": obj.get("originalDefaultWorkflow"),
            "originalIssueTypeMappings": obj.get("originalIssueTypeMappings"),
            "self": obj.get("self"),
            "updateDraftIfNeeded": obj.get("updateDraftIfNeeded")
        })
        return _obj


