# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from typing import Optional, Set
from typing_extensions import Self

class WorkflowSchemePayload(BaseModel):
    """
    The payload for creating a workflow scheme. See https://www.atlassian.com/software/jira/guides/workflows/overview\\#what-is-a-jira-workflow-scheme
    """ # noqa: E501
    default_workflow: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="defaultWorkflow")
    description: Optional[StrictStr] = Field(default=None, description="The description of the workflow scheme")
    explicit_mappings: Optional[Dict[str, ProjectCreateResourceIdentifier]] = Field(default=None, description="Association between issuetypes and workflows", alias="explicitMappings")
    name: Optional[StrictStr] = Field(default=None, description="The name of the workflow scheme")
    pcri: Optional[ProjectCreateResourceIdentifier] = None
    __properties: ClassVar[List[str]] = ["defaultWorkflow", "description", "explicitMappings", "name", "pcri"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowSchemePayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_workflow
        if self.default_workflow:
            _dict['defaultWorkflow'] = self.default_workflow.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in explicit_mappings (dict)
        _field_dict = {}
        if self.explicit_mappings:
            for _key_explicit_mappings in self.explicit_mappings:
                if self.explicit_mappings[_key_explicit_mappings]:
                    _field_dict[_key_explicit_mappings] = self.explicit_mappings[_key_explicit_mappings].to_dict()
            _dict['explicitMappings'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of pcri
        if self.pcri:
            _dict['pcri'] = self.pcri.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowSchemePayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultWorkflow": ProjectCreateResourceIdentifier.from_dict(obj["defaultWorkflow"]) if obj.get("defaultWorkflow") is not None else None,
            "description": obj.get("description"),
            "explicitMappings": dict(
                (_k, ProjectCreateResourceIdentifier.from_dict(_v))
                for _k, _v in obj["explicitMappings"].items()
            )
            if obj.get("explicitMappings") is not None
            else None,
            "name": obj.get("name"),
            "pcri": ProjectCreateResourceIdentifier.from_dict(obj["pcri"]) if obj.get("pcri") is not None else None
        })
        return _obj


