# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.document_version import DocumentVersion
from devopso.clients.jira_cloud.models.workflow_metadata_and_issue_type_rest_model import WorkflowMetadataAndIssueTypeRestModel
from devopso.clients.jira_cloud.models.workflow_metadata_rest_model import WorkflowMetadataRestModel
from devopso.clients.jira_cloud.models.workflow_scope import WorkflowScope
from typing import Optional, Set
from typing_extensions import Self

class WorkflowSchemeReadResponse(BaseModel):
    """
    WorkflowSchemeReadResponse
    """ # noqa: E501
    default_workflow: Optional[WorkflowMetadataRestModel] = Field(default=None, alias="defaultWorkflow")
    description: Optional[StrictStr] = Field(default=None, description="The description of the workflow scheme.")
    id: StrictStr = Field(description="The ID of the workflow scheme.")
    name: StrictStr = Field(description="The name of the workflow scheme.")
    scope: WorkflowScope
    task_id: Optional[StrictStr] = Field(default=None, description="Indicates if there's an [asynchronous task](#async-operations) for this workflow scheme.", alias="taskId")
    version: DocumentVersion
    workflows_for_issue_types: List[WorkflowMetadataAndIssueTypeRestModel] = Field(description="Mappings from workflows to issue types.", alias="workflowsForIssueTypes")
    __properties: ClassVar[List[str]] = ["defaultWorkflow", "description", "id", "name", "scope", "taskId", "version", "workflowsForIssueTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowSchemeReadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_workflow
        if self.default_workflow:
            _dict['defaultWorkflow'] = self.default_workflow.to_dict()
        # override the default output from pydantic by calling `to_dict()` of scope
        if self.scope:
            _dict['scope'] = self.scope.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in workflows_for_issue_types (list)
        _items = []
        if self.workflows_for_issue_types:
            for _item_workflows_for_issue_types in self.workflows_for_issue_types:
                if _item_workflows_for_issue_types:
                    _items.append(_item_workflows_for_issue_types.to_dict())
            _dict['workflowsForIssueTypes'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if task_id (nullable) is None
        # and model_fields_set contains the field
        if self.task_id is None and "task_id" in self.model_fields_set:
            _dict['taskId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowSchemeReadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultWorkflow": WorkflowMetadataRestModel.from_dict(obj["defaultWorkflow"]) if obj.get("defaultWorkflow") is not None else None,
            "description": obj.get("description"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "scope": WorkflowScope.from_dict(obj["scope"]) if obj.get("scope") is not None else None,
            "taskId": obj.get("taskId"),
            "version": DocumentVersion.from_dict(obj["version"]) if obj.get("version") is not None else None,
            "workflowsForIssueTypes": [WorkflowMetadataAndIssueTypeRestModel.from_dict(_item) for _item in obj["workflowsForIssueTypes"]] if obj.get("workflowsForIssueTypes") is not None else None
        })
        return _obj


