# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.document_version import DocumentVersion
from devopso.clients.jira_cloud.models.mappings_by_issue_type_override import MappingsByIssueTypeOverride
from devopso.clients.jira_cloud.models.mappings_by_workflow import MappingsByWorkflow
from devopso.clients.jira_cloud.models.workflow_scheme_association import WorkflowSchemeAssociation
from typing import Optional, Set
from typing_extensions import Self

class WorkflowSchemeUpdateRequest(BaseModel):
    """
    The update workflow scheme payload.
    """ # noqa: E501
    default_workflow_id: Optional[StrictStr] = Field(default=None, description="The ID of the workflow for issue types without having a mapping defined in this workflow scheme. Only used in global-scoped workflow schemes. If the `defaultWorkflowId` isn't specified, this is set to *Jira Workflow (jira)*.", alias="defaultWorkflowId")
    description: StrictStr = Field(description="The new description for this workflow scheme.")
    id: StrictStr = Field(description="The ID of this workflow scheme.")
    name: StrictStr = Field(description="The new name for this workflow scheme.")
    status_mappings_by_issue_type_override: Optional[List[MappingsByIssueTypeOverride]] = Field(default=None, description="Overrides, for the selected issue types, any status mappings provided in `statusMappingsByWorkflows`. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.", alias="statusMappingsByIssueTypeOverride")
    status_mappings_by_workflows: Optional[List[MappingsByWorkflow]] = Field(default=None, description="The status mappings by workflows. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.", alias="statusMappingsByWorkflows")
    version: DocumentVersion
    workflows_for_issue_types: Optional[List[WorkflowSchemeAssociation]] = Field(default=None, description="Mappings from workflows to issue types.", alias="workflowsForIssueTypes")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["defaultWorkflowId", "description", "id", "name", "statusMappingsByIssueTypeOverride", "statusMappingsByWorkflows", "version", "workflowsForIssueTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowSchemeUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in status_mappings_by_issue_type_override (list)
        _items = []
        if self.status_mappings_by_issue_type_override:
            for _item_status_mappings_by_issue_type_override in self.status_mappings_by_issue_type_override:
                if _item_status_mappings_by_issue_type_override:
                    _items.append(_item_status_mappings_by_issue_type_override.to_dict())
            _dict['statusMappingsByIssueTypeOverride'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in status_mappings_by_workflows (list)
        _items = []
        if self.status_mappings_by_workflows:
            for _item_status_mappings_by_workflows in self.status_mappings_by_workflows:
                if _item_status_mappings_by_workflows:
                    _items.append(_item_status_mappings_by_workflows.to_dict())
            _dict['statusMappingsByWorkflows'] = _items
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in workflows_for_issue_types (list)
        _items = []
        if self.workflows_for_issue_types:
            for _item_workflows_for_issue_types in self.workflows_for_issue_types:
                if _item_workflows_for_issue_types:
                    _items.append(_item_workflows_for_issue_types.to_dict())
            _dict['workflowsForIssueTypes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowSchemeUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultWorkflowId": obj.get("defaultWorkflowId"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "statusMappingsByIssueTypeOverride": [MappingsByIssueTypeOverride.from_dict(_item) for _item in obj["statusMappingsByIssueTypeOverride"]] if obj.get("statusMappingsByIssueTypeOverride") is not None else None,
            "statusMappingsByWorkflows": [MappingsByWorkflow.from_dict(_item) for _item in obj["statusMappingsByWorkflows"]] if obj.get("statusMappingsByWorkflows") is not None else None,
            "version": DocumentVersion.from_dict(obj["version"]) if obj.get("version") is not None else None,
            "workflowsForIssueTypes": [WorkflowSchemeAssociation.from_dict(_item) for _item in obj["workflowsForIssueTypes"]] if obj.get("workflowsForIssueTypes") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


