# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.required_mapping_by_issue_type import RequiredMappingByIssueType
from devopso.clients.jira_cloud.models.required_mapping_by_workflows import RequiredMappingByWorkflows
from devopso.clients.jira_cloud.models.status_metadata import StatusMetadata
from devopso.clients.jira_cloud.models.statuses_per_workflow import StatusesPerWorkflow
from typing import Optional, Set
from typing_extensions import Self

class WorkflowSchemeUpdateRequiredMappingsResponse(BaseModel):
    """
    WorkflowSchemeUpdateRequiredMappingsResponse
    """ # noqa: E501
    status_mappings_by_issue_types: Optional[List[RequiredMappingByIssueType]] = Field(default=None, description="The list of required status mappings by issue type.", alias="statusMappingsByIssueTypes")
    status_mappings_by_workflows: Optional[List[RequiredMappingByWorkflows]] = Field(default=None, description="The list of required status mappings by workflow.", alias="statusMappingsByWorkflows")
    statuses: Optional[List[StatusMetadata]] = Field(default=None, description="The details of the statuses in the associated workflows.")
    statuses_per_workflow: Optional[List[StatusesPerWorkflow]] = Field(default=None, description="The statuses associated with each workflow.", alias="statusesPerWorkflow")
    __properties: ClassVar[List[str]] = ["statusMappingsByIssueTypes", "statusMappingsByWorkflows", "statuses", "statusesPerWorkflow"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowSchemeUpdateRequiredMappingsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in status_mappings_by_issue_types (list)
        _items = []
        if self.status_mappings_by_issue_types:
            for _item_status_mappings_by_issue_types in self.status_mappings_by_issue_types:
                if _item_status_mappings_by_issue_types:
                    _items.append(_item_status_mappings_by_issue_types.to_dict())
            _dict['statusMappingsByIssueTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in status_mappings_by_workflows (list)
        _items = []
        if self.status_mappings_by_workflows:
            for _item_status_mappings_by_workflows in self.status_mappings_by_workflows:
                if _item_status_mappings_by_workflows:
                    _items.append(_item_status_mappings_by_workflows.to_dict())
            _dict['statusMappingsByWorkflows'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in statuses (list)
        _items = []
        if self.statuses:
            for _item_statuses in self.statuses:
                if _item_statuses:
                    _items.append(_item_statuses.to_dict())
            _dict['statuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in statuses_per_workflow (list)
        _items = []
        if self.statuses_per_workflow:
            for _item_statuses_per_workflow in self.statuses_per_workflow:
                if _item_statuses_per_workflow:
                    _items.append(_item_statuses_per_workflow.to_dict())
            _dict['statusesPerWorkflow'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowSchemeUpdateRequiredMappingsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "statusMappingsByIssueTypes": [RequiredMappingByIssueType.from_dict(_item) for _item in obj["statusMappingsByIssueTypes"]] if obj.get("statusMappingsByIssueTypes") is not None else None,
            "statusMappingsByWorkflows": [RequiredMappingByWorkflows.from_dict(_item) for _item in obj["statusMappingsByWorkflows"]] if obj.get("statusMappingsByWorkflows") is not None else None,
            "statuses": [StatusMetadata.from_dict(_item) for _item in obj["statuses"]] if obj.get("statuses") is not None else None,
            "statusesPerWorkflow": [StatusesPerWorkflow.from_dict(_item) for _item in obj["statusesPerWorkflow"]] if obj.get("statusesPerWorkflow") is not None else None
        })
        return _obj


