# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.app_workflow_transition_rule import AppWorkflowTransitionRule
from devopso.clients.jira_cloud.models.workflow_id import WorkflowId
from typing import Optional, Set
from typing_extensions import Self

class WorkflowTransitionRules(BaseModel):
    """
    A workflow with transition rules.
    """ # noqa: E501
    conditions: Optional[List[AppWorkflowTransitionRule]] = Field(default=None, description="The list of conditions within the workflow.")
    post_functions: Optional[List[AppWorkflowTransitionRule]] = Field(default=None, description="The list of post functions within the workflow.", alias="postFunctions")
    validators: Optional[List[AppWorkflowTransitionRule]] = Field(default=None, description="The list of validators within the workflow.")
    workflow_id: WorkflowId = Field(alias="workflowId")
    __properties: ClassVar[List[str]] = ["conditions", "postFunctions", "validators", "workflowId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowTransitionRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item_conditions in self.conditions:
                if _item_conditions:
                    _items.append(_item_conditions.to_dict())
            _dict['conditions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in post_functions (list)
        _items = []
        if self.post_functions:
            for _item_post_functions in self.post_functions:
                if _item_post_functions:
                    _items.append(_item_post_functions.to_dict())
            _dict['postFunctions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in validators (list)
        _items = []
        if self.validators:
            for _item_validators in self.validators:
                if _item_validators:
                    _items.append(_item_validators.to_dict())
            _dict['validators'] = _items
        # override the default output from pydantic by calling `to_dict()` of workflow_id
        if self.workflow_id:
            _dict['workflowId'] = self.workflow_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowTransitionRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "conditions": [AppWorkflowTransitionRule.from_dict(_item) for _item in obj["conditions"]] if obj.get("conditions") is not None else None,
            "postFunctions": [AppWorkflowTransitionRule.from_dict(_item) for _item in obj["postFunctions"]] if obj.get("postFunctions") is not None else None,
            "validators": [AppWorkflowTransitionRule.from_dict(_item) for _item in obj["validators"]] if obj.get("validators") is not None else None,
            "workflowId": WorkflowId.from_dict(obj["workflowId"]) if obj.get("workflowId") is not None else None
        })
        return _obj


