# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.workflow_element_reference import WorkflowElementReference
from typing import Optional, Set
from typing_extensions import Self

class WorkflowValidationError(BaseModel):
    """
    The details about a workflow validation error.
    """ # noqa: E501
    code: Optional[StrictStr] = Field(default=None, description="An error code.")
    element_reference: Optional[WorkflowElementReference] = Field(default=None, alias="elementReference")
    level: Optional[StrictStr] = Field(default=None, description="The validation error level.")
    message: Optional[StrictStr] = Field(default=None, description="An error message.")
    type: Optional[StrictStr] = Field(default=None, description="The type of element the error or warning references.")
    __properties: ClassVar[List[str]] = ["code", "elementReference", "level", "message", "type"]

    @field_validator('level')
    def level_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['WARNING', 'ERROR']):
            raise ValueError("must be one of enum values ('WARNING', 'ERROR')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RULE', 'STATUS', 'STATUS_LAYOUT', 'STATUS_PROPERTY', 'WORKFLOW', 'TRANSITION', 'TRANSITION_PROPERTY', 'SCOPE', 'STATUS_MAPPING', 'TRIGGER']):
            raise ValueError("must be one of enum values ('RULE', 'STATUS', 'STATUS_LAYOUT', 'STATUS_PROPERTY', 'WORKFLOW', 'TRANSITION', 'TRANSITION_PROPERTY', 'SCOPE', 'STATUS_MAPPING', 'TRIGGER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowValidationError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of element_reference
        if self.element_reference:
            _dict['elementReference'] = self.element_reference.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowValidationError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code"),
            "elementReference": WorkflowElementReference.from_dict(obj["elementReference"]) if obj.get("elementReference") is not None else None,
            "level": obj.get("level"),
            "message": obj.get("message"),
            "type": obj.get("type")
        })
        return _obj


