# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.non_working_day import NonWorkingDay
from typing import Optional, Set
from typing_extensions import Self

class WorkingDaysConfig(BaseModel):
    """
    Working days configuration
    """ # noqa: E501
    friday: Optional[StrictBool] = None
    id: Optional[StrictInt] = None
    monday: Optional[StrictBool] = None
    non_working_days: Optional[List[NonWorkingDay]] = Field(default=None, alias="nonWorkingDays")
    saturday: Optional[StrictBool] = None
    sunday: Optional[StrictBool] = None
    thursday: Optional[StrictBool] = None
    timezone_id: Optional[StrictStr] = Field(default=None, alias="timezoneId")
    tuesday: Optional[StrictBool] = None
    wednesday: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["friday", "id", "monday", "nonWorkingDays", "saturday", "sunday", "thursday", "timezoneId", "tuesday", "wednesday"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkingDaysConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in non_working_days (list)
        _items = []
        if self.non_working_days:
            for _item_non_working_days in self.non_working_days:
                if _item_non_working_days:
                    _items.append(_item_non_working_days.to_dict())
            _dict['nonWorkingDays'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkingDaysConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "friday": obj.get("friday"),
            "id": obj.get("id"),
            "monday": obj.get("monday"),
            "nonWorkingDays": [NonWorkingDay.from_dict(_item) for _item in obj["nonWorkingDays"]] if obj.get("nonWorkingDays") is not None else None,
            "saturday": obj.get("saturday"),
            "sunday": obj.get("sunday"),
            "thursday": obj.get("thursday"),
            "timezoneId": obj.get("timezoneId"),
            "tuesday": obj.get("tuesday"),
            "wednesday": obj.get("wednesday")
        })
        return _obj


