# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.entity_property import EntityProperty
from devopso.clients.jira_cloud.models.user_details import UserDetails
from devopso.clients.jira_cloud.models.visibility import Visibility
from typing import Optional, Set
from typing_extensions import Self

class Worklog(BaseModel):
    """
    Details of a worklog.
    """ # noqa: E501
    author: Optional[UserDetails] = Field(default=None, description="Details of the user who created the worklog.")
    comment: Optional[Any] = Field(default=None, description="A comment about the worklog in [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/). Optional when creating or updating a worklog.")
    created: Optional[datetime] = Field(default=None, description="The datetime on which the worklog was created.")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the worklog record.")
    issue_id: Optional[StrictStr] = Field(default=None, description="The ID of the issue this worklog is for.", alias="issueId")
    properties: Optional[List[EntityProperty]] = Field(default=None, description="Details of properties for the worklog. Optional when creating or updating a worklog.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the worklog item.", alias="self")
    started: Optional[datetime] = Field(default=None, description="The datetime on which the worklog effort was started. Required when creating a worklog. Optional when updating a worklog.")
    time_spent: Optional[StrictStr] = Field(default=None, description="The time spent working on the issue as days (\\#d), hours (\\#h), or minutes (\\#m or \\#). Required when creating a worklog if `timeSpentSeconds` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpentSecond` is provided.", alias="timeSpent")
    time_spent_seconds: Optional[StrictInt] = Field(default=None, description="The time in seconds spent working on the issue. Required when creating a worklog if `timeSpent` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpent` is provided.", alias="timeSpentSeconds")
    update_author: Optional[UserDetails] = Field(default=None, description="Details of the user who last updated the worklog.", alias="updateAuthor")
    updated: Optional[datetime] = Field(default=None, description="The datetime on which the worklog was last updated.")
    visibility: Optional[Visibility] = Field(default=None, description="Details about any restrictions in the visibility of the worklog. Optional when creating or updating a worklog.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["author", "comment", "created", "id", "issueId", "properties", "self", "started", "timeSpent", "timeSpentSeconds", "updateAuthor", "updated", "visibility"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Worklog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "author",
            "created",
            "id",
            "issue_id",
            "var_self",
            "update_author",
            "updated",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item_properties in self.properties:
                if _item_properties:
                    _items.append(_item_properties.to_dict())
            _dict['properties'] = _items
        # override the default output from pydantic by calling `to_dict()` of update_author
        if self.update_author:
            _dict['updateAuthor'] = self.update_author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of visibility
        if self.visibility:
            _dict['visibility'] = self.visibility.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Worklog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "author": UserDetails.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "comment": obj.get("comment"),
            "created": obj.get("created"),
            "id": obj.get("id"),
            "issueId": obj.get("issueId"),
            "properties": [EntityProperty.from_dict(_item) for _item in obj["properties"]] if obj.get("properties") is not None else None,
            "self": obj.get("self"),
            "started": obj.get("started"),
            "timeSpent": obj.get("timeSpent"),
            "timeSpentSeconds": obj.get("timeSpentSeconds"),
            "updateAuthor": UserDetails.from_dict(obj["updateAuthor"]) if obj.get("updateAuthor") is not None else None,
            "updated": obj.get("updated"),
            "visibility": Visibility.from_dict(obj["visibility"]) if obj.get("visibility") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


