# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.get_all_boards200_response_values_inner_admins import GetAllBoards200ResponseValuesInnerAdmins
from devopso.clients.jira_cloud_agile.models.get_all_boards200_response_values_inner_location import GetAllBoards200ResponseValuesInnerLocation
from typing import Optional, Set
from typing_extensions import Self

class Board(BaseModel):
    """
    Details about a board.
    """ # noqa: E501
    admins: Optional[GetAllBoards200ResponseValuesInnerAdmins] = None
    can_edit: Optional[StrictBool] = Field(default=None, description="Whether the board can be edited.", alias="canEdit")
    favourite: Optional[StrictBool] = Field(default=None, description="Whether the board is selected as a favorite.")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the board.")
    is_private: Optional[StrictBool] = Field(default=None, description="Whether the board is private.", alias="isPrivate")
    location: Optional[GetAllBoards200ResponseValuesInnerLocation] = None
    name: Optional[StrictStr] = Field(default=None, description="The name of the board.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the board.", alias="self")
    type: Optional[StrictStr] = Field(default=None, description="The type the board.")
    __properties: ClassVar[List[str]] = ["admins", "canEdit", "favourite", "id", "isPrivate", "location", "name", "self", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Board from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "can_edit",
            "favourite",
            "is_private",
            "var_self",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of admins
        if self.admins:
            _dict['admins'] = self.admins.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Board from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "admins": GetAllBoards200ResponseValuesInnerAdmins.from_dict(obj["admins"]) if obj.get("admins") is not None else None,
            "canEdit": obj.get("canEdit"),
            "favourite": obj.get("favourite"),
            "id": obj.get("id"),
            "isPrivate": obj.get("isPrivate"),
            "location": GetAllBoards200ResponseValuesInnerLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "name": obj.get("name"),
            "self": obj.get("self"),
            "type": obj.get("type")
        })
        return _obj


