# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.commit1 import Commit1
from devopso.clients.jira_cloud_agile.models.issue_id_or_keys_association import IssueIdOrKeysAssociation
from typing import Optional, Set
from typing_extensions import Self

class Branch(BaseModel):
    """
    Represents a branch in the version control system
    """ # noqa: E501
    id: Annotated[str, Field(strict=True, max_length=1024)] = Field(description="The ID of this entity. Will be used for cross entity linking. Must be unique by entity type within a repository, i.e., only one commit can have ID 'X' in repository 'Y'. But adding, e.g., a branch with ID 'X' to repository 'Y' is acceptable. Only alphanumeric characters, and '~.-_', are allowed. Max length is 1024 characters.")
    issue_keys: Optional[Annotated[List[StrictStr], Field(min_length=1, max_length=500)]] = Field(default=None, description="List of issues keys that this entity is associated with. They must be valid Jira issue keys.", alias="issueKeys")
    associations: Optional[List[IssueIdOrKeysAssociation]] = Field(default=None, description="The Jira issue keys or IDs to associate the branch with.")
    update_sequence_id: StrictInt = Field(description="An ID used to apply an ordering to updates for this entity in the case of out-of-order receipt of update requests. This can be any monotonically increasing number. A suggested implementation is to use epoch millis from the provider system, but other alternatives are valid (e.g. a provider could store a counter against each entity and increment that on each update to Jira). Updates for an entity that are received with an updateSqeuenceId lower than what is currently stored will be ignored.", alias="updateSequenceId")
    name: Annotated[str, Field(strict=True, max_length=512)] = Field(description="The name of the branch. Max length is 512 characters.")
    last_commit: Commit1 = Field(alias="lastCommit")
    create_pull_request_url: Optional[Annotated[str, Field(strict=True, max_length=2000)]] = Field(default=None, description="The URL of the page for creating a pull request from this branch. Max length is 2000 characters.", alias="createPullRequestUrl")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="The URL of the branch. Max length is 2000 characters.")
    __properties: ClassVar[List[str]] = ["id", "issueKeys", "associations", "updateSequenceId", "name", "lastCommit", "createPullRequestUrl", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Branch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associations (list)
        _items = []
        if self.associations:
            for _item_associations in self.associations:
                if _item_associations:
                    _items.append(_item_associations.to_dict())
            _dict['associations'] = _items
        # override the default output from pydantic by calling `to_dict()` of last_commit
        if self.last_commit:
            _dict['lastCommit'] = self.last_commit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Branch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "issueKeys": obj.get("issueKeys"),
            "associations": [IssueIdOrKeysAssociation.from_dict(_item) for _item in obj["associations"]] if obj.get("associations") is not None else None,
            "updateSequenceId": obj.get("updateSequenceId"),
            "name": obj.get("name"),
            "lastCommit": Commit1.from_dict(obj["lastCommit"]) if obj.get("lastCommit") is not None else None,
            "createPullRequestUrl": obj.get("createPullRequestUrl"),
            "url": obj.get("url")
        })
        return _obj


