# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.build_references import BuildReferences
from devopso.clients.jira_cloud_agile.models.issue_id_or_keys_association import IssueIdOrKeysAssociation
from devopso.clients.jira_cloud_agile.models.test_info import TestInfo
from typing import Optional, Set
from typing_extensions import Self

class BuildData(BaseModel):
    """
    Data related to a single build 
    """ # noqa: E501
    schema_version: Optional[StrictStr] = Field(default='1.0', description="The schema version used for this data.  Placeholder to support potential schema changes in the future. ", alias="schemaVersion")
    pipeline_id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="An ID that relates a sequence of builds. Depending on your use case this might be a project ID, pipeline ID, plan key etc. - whatever logical unit you use to group a sequence of builds.  The combination of `pipelineId` and `buildNumber` must uniquely identify a build you have provided. ", alias="pipelineId")
    build_number: StrictInt = Field(description="Identifies a build within the sequence of builds identified by the build `pipelineId`.  Used to identify the 'most recent' build in that sequence of builds.  The combination of `pipelineId` and `buildNumber` must uniquely identify a build you have provided. ", alias="buildNumber")
    update_sequence_number: StrictInt = Field(description="A number used to apply an order to the updates to the build, as identified by `pipelineId` and `buildNumber`, in the case of out-of-order receipt of update requests.  It must be a monotonically increasing number. For example, epoch time could be one way to generate the `updateSequenceNumber`.  Updates for a build that is received with an `updateSqeuenceNumber` less than or equal to what is currently stored will be ignored. ", alias="updateSequenceNumber")
    display_name: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The human-readable name for the build.  Will be shown in the UI. ", alias="displayName")
    description: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="An optional description to attach to this build.  This may be anything that makes sense in your system. ")
    label: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="A human-readable string that to provide information about the build. ")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="The URL to this build in your system. ")
    state: StrictStr = Field(description="The state of a build.  * `pending` - The build is queued, or some manual action is required. * `in_progress` - The build is currently running. * `successful` - The build completed successfully. * `failed` - The build failed. * `cancelled` - The build has been cancelled or stopped. * `unknown` - The build is in an unknown state. ")
    last_updated: datetime = Field(description="The last-updated timestamp to present to the user as a summary of the state of the build. ", alias="lastUpdated")
    issue_keys: Optional[Annotated[List[Annotated[str, Field(strict=True)]], Field(min_length=1, max_length=100)]] = Field(default=None, description="The Jira issue keys to associate the build information with.  You are free to associate issue keys in any way you like. However, we recommend that you use the name of the branch the build was executed on, and extract issue keys from that name using a simple regex. This has the advantage that it provides an intuitive association of builds to issue keys. ", alias="issueKeys")
    associations: Optional[List[IssueIdOrKeysAssociation]] = Field(default=None, description="The Jira issue keys or IDs to associate the build with.")
    test_info: Optional[TestInfo] = Field(default=None, alias="testInfo")
    references: Optional[Annotated[List[BuildReferences], Field(min_length=1, max_length=5)]] = Field(default=None, description="Optional information that links a build to a commit, branch etc. ")
    __properties: ClassVar[List[str]] = ["schemaVersion", "pipelineId", "buildNumber", "updateSequenceNumber", "displayName", "description", "label", "url", "state", "lastUpdated", "issueKeys", "associations", "testInfo", "references"]

    @field_validator('schema_version')
    def schema_version_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['1.0']):
            raise ValueError("must be one of enum values ('1.0')")
        return value

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'in_progress', 'successful', 'failed', 'cancelled', 'unknown']):
            raise ValueError("must be one of enum values ('pending', 'in_progress', 'successful', 'failed', 'cancelled', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BuildData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associations (list)
        _items = []
        if self.associations:
            for _item_associations in self.associations:
                if _item_associations:
                    _items.append(_item_associations.to_dict())
            _dict['associations'] = _items
        # override the default output from pydantic by calling `to_dict()` of test_info
        if self.test_info:
            _dict['testInfo'] = self.test_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BuildData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemaVersion": obj.get("schemaVersion") if obj.get("schemaVersion") is not None else '1.0',
            "pipelineId": obj.get("pipelineId"),
            "buildNumber": obj.get("buildNumber"),
            "updateSequenceNumber": obj.get("updateSequenceNumber"),
            "displayName": obj.get("displayName"),
            "description": obj.get("description"),
            "label": obj.get("label"),
            "url": obj.get("url"),
            "state": obj.get("state"),
            "lastUpdated": obj.get("lastUpdated"),
            "issueKeys": obj.get("issueKeys"),
            "associations": [IssueIdOrKeysAssociation.from_dict(_item) for _item in obj["associations"]] if obj.get("associations") is not None else None,
            "testInfo": TestInfo.from_dict(obj["testInfo"]) if obj.get("testInfo") is not None else None,
            "references": [BuildReferences.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None
        })
        return _obj


