# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.changelog_author import ChangelogAuthor
from devopso.clients.jira_cloud_agile.models.changelog_history_metadata import ChangelogHistoryMetadata
from devopso.clients.jira_cloud_agile.models.changelog_items_inner import ChangelogItemsInner
from typing import Optional, Set
from typing_extensions import Self

class Changelog(BaseModel):
    """
    A log of changes made to issue fields. Changelogs related to workflow associations are currently being deprecated.
    """ # noqa: E501
    author: Optional[ChangelogAuthor] = None
    created: Optional[datetime] = Field(default=None, description="The date on which the change took place.")
    history_metadata: Optional[ChangelogHistoryMetadata] = Field(default=None, alias="historyMetadata")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the changelog.")
    items: Optional[List[ChangelogItemsInner]] = Field(default=None, description="The list of items changed.")
    __properties: ClassVar[List[str]] = ["author", "created", "historyMetadata", "id", "items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Changelog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created",
            "id",
            "items",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of history_metadata
        if self.history_metadata:
            _dict['historyMetadata'] = self.history_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Changelog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "author": ChangelogAuthor.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "created": obj.get("created"),
            "historyMetadata": ChangelogHistoryMetadata.from_dict(obj["historyMetadata"]) if obj.get("historyMetadata") is not None else None,
            "id": obj.get("id"),
            "items": [ChangelogItemsInner.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None
        })
        return _obj


