# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.changelog_history_metadata_all_of_actor import ChangelogHistoryMetadataAllOfActor
from devopso.clients.jira_cloud_agile.models.changelog_history_metadata_all_of_cause import ChangelogHistoryMetadataAllOfCause
from devopso.clients.jira_cloud_agile.models.changelog_history_metadata_all_of_generator import ChangelogHistoryMetadataAllOfGenerator
from typing import Optional, Set
from typing_extensions import Self

class ChangelogHistoryMetadata(BaseModel):
    """
    The history metadata associated with the changed.
    """ # noqa: E501
    activity_description: Optional[StrictStr] = Field(default=None, description="The activity described in the history record.", alias="activityDescription")
    activity_description_key: Optional[StrictStr] = Field(default=None, description="The key of the activity described in the history record.", alias="activityDescriptionKey")
    actor: Optional[ChangelogHistoryMetadataAllOfActor] = None
    cause: Optional[ChangelogHistoryMetadataAllOfCause] = None
    description: Optional[StrictStr] = Field(default=None, description="The description of the history record.")
    description_key: Optional[StrictStr] = Field(default=None, description="The description key of the history record.", alias="descriptionKey")
    email_description: Optional[StrictStr] = Field(default=None, description="The description of the email address associated the history record.", alias="emailDescription")
    email_description_key: Optional[StrictStr] = Field(default=None, description="The description key of the email address associated the history record.", alias="emailDescriptionKey")
    extra_data: Optional[Dict[str, StrictStr]] = Field(default=None, description="Additional arbitrary information about the history record.", alias="extraData")
    generator: Optional[ChangelogHistoryMetadataAllOfGenerator] = None
    type: Optional[StrictStr] = Field(default=None, description="The type of the history record.")
    __properties: ClassVar[List[str]] = ["activityDescription", "activityDescriptionKey", "actor", "cause", "description", "descriptionKey", "emailDescription", "emailDescriptionKey", "extraData", "generator", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChangelogHistoryMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of actor
        if self.actor:
            _dict['actor'] = self.actor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cause
        if self.cause:
            _dict['cause'] = self.cause.to_dict()
        # override the default output from pydantic by calling `to_dict()` of generator
        if self.generator:
            _dict['generator'] = self.generator.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChangelogHistoryMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "activityDescription": obj.get("activityDescription"),
            "activityDescriptionKey": obj.get("activityDescriptionKey"),
            "actor": ChangelogHistoryMetadataAllOfActor.from_dict(obj["actor"]) if obj.get("actor") is not None else None,
            "cause": ChangelogHistoryMetadataAllOfCause.from_dict(obj["cause"]) if obj.get("cause") is not None else None,
            "description": obj.get("description"),
            "descriptionKey": obj.get("descriptionKey"),
            "emailDescription": obj.get("emailDescription"),
            "emailDescriptionKey": obj.get("emailDescriptionKey"),
            "extraData": obj.get("extraData"),
            "generator": ChangelogHistoryMetadataAllOfGenerator.from_dict(obj["generator"]) if obj.get("generator") is not None else None,
            "type": obj.get("type")
        })
        return _obj


