# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ChangelogItemsInner(BaseModel):
    """
    A change item.
    """ # noqa: E501
    var_field: Optional[StrictStr] = Field(default=None, description="The name of the field changed.", alias="field")
    field_id: Optional[StrictStr] = Field(default=None, description="The ID of the field changed.", alias="fieldId")
    fieldtype: Optional[StrictStr] = Field(default=None, description="The type of the field changed.")
    var_from: Optional[StrictStr] = Field(default=None, description="The details of the original value.", alias="from")
    from_string: Optional[StrictStr] = Field(default=None, description="The details of the original value as a string.", alias="fromString")
    to: Optional[StrictStr] = Field(default=None, description="The details of the new value.")
    to_string: Optional[StrictStr] = Field(default=None, description="The details of the new value as a string.", alias="toString")
    __properties: ClassVar[List[str]] = ["field", "fieldId", "fieldtype", "from", "fromString", "to", "toString"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChangelogItemsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "var_field",
            "field_id",
            "fieldtype",
            "var_from",
            "from_string",
            "to",
            "to_string",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChangelogItemsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "field": obj.get("field"),
            "fieldId": obj.get("fieldId"),
            "fieldtype": obj.get("fieldtype"),
            "from": obj.get("from"),
            "fromString": obj.get("fromString"),
            "to": obj.get("to"),
            "toString": obj.get("toString")
        })
        return _obj


