# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.get_configuration200_response_column_config_columns_inner_statuses_inner import GetConfiguration200ResponseColumnConfigColumnsInnerStatusesInner
from typing import Optional, Set
from typing_extensions import Self

class ColumnBean(BaseModel):
    """
    ColumnBean
    """ # noqa: E501
    max: Optional[StrictInt] = None
    min: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    statuses: Optional[List[GetConfiguration200ResponseColumnConfigColumnsInnerStatusesInner]] = None
    __properties: ClassVar[List[str]] = ["max", "min", "name", "statuses"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ColumnBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in statuses (list)
        _items = []
        if self.statuses:
            for _item_statuses in self.statuses:
                if _item_statuses:
                    _items.append(_item_statuses.to_dict())
            _dict['statuses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ColumnBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "max": obj.get("max"),
            "min": obj.get("min"),
            "name": obj.get("name"),
            "statuses": [GetConfiguration200ResponseColumnConfigColumnsInnerStatusesInner.from_dict(_item) for _item in obj["statuses"]] if obj.get("statuses") is not None else None
        })
        return _obj


