# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.author import Author
from devopso.clients.jira_cloud_agile.models.file import File
from typing import Optional, Set
from typing_extensions import Self

class Commit1(BaseModel):
    """
    Represents a commit in the version control system.
    """ # noqa: E501
    id: StrictStr = Field(description="The identifier or hash of the commit. Will be used for cross entity linking. Must be unique for all commits within a repository, i.e., only one commit can have ID 'X' in repository 'Y'. But adding, e.g., a branch with ID 'X' to repository 'Y' is acceptable. Only alphanumeric characters, and '~.-_', are allowed. Max length is 1024 characters")
    issue_keys: Annotated[List[StrictStr], Field(min_length=1, max_length=500)] = Field(description="List of issues keys that this entity is associated with. They must be valid Jira issue keys.", alias="issueKeys")
    update_sequence_id: StrictInt = Field(description="An ID used to apply an ordering to updates for this entity in the case of out-of-order receipt of update requests. This can be any monotonically increasing number. A suggested implementation is to use epoch millis from the provider system, but other alternatives are valid (e.g. a provider could store a counter against each entity and increment that on each update to Jira). Updates for an entity that are received with an updateSqeuenceId lower than what is currently stored will be ignored.", alias="updateSequenceId")
    hash: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Deprecated. Use the id field instead.")
    flags: Optional[List[StrictStr]] = Field(default=None, description="The set of flags for this commit")
    message: Annotated[str, Field(strict=True, max_length=1024)] = Field(description="The commit message. Max length is 1024 characters. If anything longer is supplied, it will be truncated down to 1024 characters.")
    author: Author
    file_count: Annotated[int, Field(strict=True, ge=0)] = Field(description="The total number of files added, removed, or modified by this commit", alias="fileCount")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="The URL of this commit. Max length is 2000 characters.")
    files: Optional[Annotated[List[File], Field(max_length=10)]] = Field(default=None, description="List of file changes. Max number of files is 10. Currently, only the first 5 files are shown (sorted by path) in the UI. This UI behavior may change without notice.")
    author_timestamp: StrictStr = Field(description="The author timestamp of this commit. Formatted as a UTC ISO 8601 date time format.", alias="authorTimestamp")
    display_id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="Shortened identifier for this commit, used for display. Max length is 255 characters.", alias="displayId")
    __properties: ClassVar[List[str]] = ["id", "issueKeys", "updateSequenceId", "hash", "flags", "message", "author", "fileCount", "url", "files", "authorTimestamp", "displayId"]

    @field_validator('flags')
    def flags_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['MERGE_COMMIT']):
                raise ValueError("each list item must be one of ('MERGE_COMMIT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Commit1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files:
                    _items.append(_item_files.to_dict())
            _dict['files'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Commit1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "issueKeys": obj.get("issueKeys"),
            "updateSequenceId": obj.get("updateSequenceId"),
            "hash": obj.get("hash"),
            "flags": obj.get("flags"),
            "message": obj.get("message"),
            "author": Author.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "fileCount": obj.get("fileCount"),
            "url": obj.get("url"),
            "files": [File.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None,
            "authorTimestamp": obj.get("authorTimestamp"),
            "displayId": obj.get("displayId")
        })
        return _obj


