# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Component(BaseModel):
    """
    Data related to a specific component in a specific workspace that is affected by incidents. 
    """ # noqa: E501
    schema_version: StrictStr = Field(description="The DevOpsComponentData schema version used for this devops component data.  Placeholder to support potential schema changes in the future. ", alias="schemaVersion")
    id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The identifier for the DevOps Component. Must be unique for a given Provider. ")
    update_sequence_number: StrictInt = Field(description="An ID used to apply an ordering to updates for this DevOps Component in the case of out-of-order receipt of update requests.  This can be any monotonically increasing number. A suggested implementation is to use epoch millis from the Provider system, but other alternatives are valid (e.g. a Provider could store a counter against each DevOps Component and increment that on each update to Jira).  Updates for a DevOps Component that are received with an updateSqeuenceId lower than what is currently stored will be ignored. ", alias="updateSequenceNumber")
    name: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The human-readable name for the DevOps Component. Will be shown in the UI. ")
    provider_name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The human-readable name for the Provider that owns this DevOps Component. Will be shown in the UI. ", alias="providerName")
    description: Annotated[str, Field(strict=True, max_length=5000)] = Field(description="A description of the DevOps Component in Markdown format. Will be shown in the UI. ")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="A URL users can use to link to a summary view of this devops component, if appropriate.  This could be any location that makes sense in the Provider system (e.g. if the summary information comes from a specific project, it might make sense to link the user to the component in that project). ")
    avatar_url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="A URL to display a logo representing this devops component, if available. ", alias="avatarUrl")
    tier: StrictStr = Field(description="The tier of the component. Will be shown in the UI. ")
    component_type: StrictStr = Field(description="The type of the component. Will be shown in the UI. ", alias="componentType")
    last_updated: datetime = Field(description="The last-updated timestamp to present to the user the last time the DevOps Component was updated.  Expected format is an RFC3339 formatted string. ", alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["schemaVersion", "id", "updateSequenceNumber", "name", "providerName", "description", "url", "avatarUrl", "tier", "componentType", "lastUpdated"]

    @field_validator('schema_version')
    def schema_version_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['1.0']):
            raise ValueError("must be one of enum values ('1.0')")
        return value

    @field_validator('tier')
    def tier_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Tier 1', 'Tier 2', 'Tier 3', 'Tier 4']):
            raise ValueError("must be one of enum values ('Tier 1', 'Tier 2', 'Tier 3', 'Tier 4')")
        return value

    @field_validator('component_type')
    def component_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Service', 'Application', 'Library', 'Capability', 'Cloud resource', 'Data pipeline', 'Machine learning model', 'UI element', 'Website', 'Other']):
            raise ValueError("must be one of enum values ('Service', 'Application', 'Library', 'Capability', 'Cloud resource', 'Data pipeline', 'Machine learning model', 'UI element', 'Website', 'Other')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Component from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Component from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemaVersion": obj.get("schemaVersion") if obj.get("schemaVersion") is not None else '1.0',
            "id": obj.get("id"),
            "updateSequenceNumber": obj.get("updateSequenceNumber"),
            "name": obj.get("name"),
            "providerName": obj.get("providerName"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "avatarUrl": obj.get("avatarUrl"),
            "tier": obj.get("tier"),
            "componentType": obj.get("componentType"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


