# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.command import Command
from devopso.clients.jira_cloud_agile.models.deployment_data_associations_inner import DeploymentDataAssociationsInner
from devopso.clients.jira_cloud_agile.models.environment import Environment
from devopso.clients.jira_cloud_agile.models.pipeline import Pipeline
from typing import Optional, Set
from typing_extensions import Self

class DeploymentData1(BaseModel):
    """
    Data related to a specific deployment in a specific environment that the deployment is present in. Must specify one of `issueKeys` or `associations`. 
    """ # noqa: E501
    deployment_sequence_number: StrictInt = Field(description="This is the identifier for the deployment. It must be unique for the specified pipeline and environment. It must be a monotonically increasing number, as this is used to sequence the deployments. ", alias="deploymentSequenceNumber")
    update_sequence_number: StrictInt = Field(description="A number used to apply an order to the updates to the deployment, as identified by the deploymentSequenceNumber, in the case of out-of-order receipt of update requests. It must be a monotonically increasing number. For example, epoch time could be one way to generate the updateSequenceNumber. ", alias="updateSequenceNumber")
    issue_keys: Optional[Annotated[List[Annotated[str, Field(strict=True)]], Field(min_length=1, max_length=100)]] = Field(default=None, description="Deprecated. The Jira issue keys to associate the Deployment information with. Should replace this field with the \"associations\" field to associate Deployment information with issueKeys or other types of associations. ", alias="issueKeys")
    associations: Optional[Annotated[List[DeploymentDataAssociationsInner], Field(min_length=1, max_length=3)]] = Field(default=None, description="The entities to associate the Deployment information with. ")
    display_name: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The human-readable name for the deployment. Will be shown in the UI. ", alias="displayName")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="A URL users can use to link to this deployment, in this environment. ")
    description: Annotated[str, Field(strict=True, max_length=255)] = Field(description="A short description of the deployment ")
    last_updated: datetime = Field(description="The last-updated timestamp to present to the user as a summary of the state of the deployment. ", alias="lastUpdated")
    label: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="An (optional) additional label that may be displayed with deployment information. Can be used to display version information etc. for the deployment. ")
    duration: Optional[StrictInt] = Field(default=None, description="The duration of the deployment (in seconds). ")
    state: StrictStr = Field(description="The state of the deployment ")
    pipeline: Pipeline
    environment: Environment
    commands: Optional[List[Command]] = Field(default=None, description="A list of commands to be actioned for this Deployment ")
    schema_version: Optional[StrictStr] = Field(default='1.0', description="The DeploymentData schema version used for this deployment data.  Placeholder to support potential schema changes in the future. ", alias="schemaVersion")
    __properties: ClassVar[List[str]] = ["deploymentSequenceNumber", "updateSequenceNumber", "issueKeys", "associations", "displayName", "url", "description", "lastUpdated", "label", "duration", "state", "pipeline", "environment", "commands", "schemaVersion"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['unknown', 'pending', 'in_progress', 'cancelled', 'failed', 'rolled_back', 'successful']):
            raise ValueError("must be one of enum values ('unknown', 'pending', 'in_progress', 'cancelled', 'failed', 'rolled_back', 'successful')")
        return value

    @field_validator('schema_version')
    def schema_version_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['1.0']):
            raise ValueError("must be one of enum values ('1.0')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeploymentData1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associations (list)
        _items = []
        if self.associations:
            for _item_associations in self.associations:
                if _item_associations:
                    _items.append(_item_associations.to_dict())
            _dict['associations'] = _items
        # override the default output from pydantic by calling `to_dict()` of pipeline
        if self.pipeline:
            _dict['pipeline'] = self.pipeline.to_dict()
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in commands (list)
        _items = []
        if self.commands:
            for _item_commands in self.commands:
                if _item_commands:
                    _items.append(_item_commands.to_dict())
            _dict['commands'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeploymentData1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deploymentSequenceNumber": obj.get("deploymentSequenceNumber"),
            "updateSequenceNumber": obj.get("updateSequenceNumber"),
            "issueKeys": obj.get("issueKeys"),
            "associations": [DeploymentDataAssociationsInner.from_dict(_item) for _item in obj["associations"]] if obj.get("associations") is not None else None,
            "displayName": obj.get("displayName"),
            "url": obj.get("url"),
            "description": obj.get("description"),
            "lastUpdated": obj.get("lastUpdated"),
            "label": obj.get("label"),
            "duration": obj.get("duration"),
            "state": obj.get("state"),
            "pipeline": Pipeline.from_dict(obj["pipeline"]) if obj.get("pipeline") is not None else None,
            "environment": Environment.from_dict(obj["environment"]) if obj.get("environment") is not None else None,
            "commands": [Command.from_dict(_item) for _item in obj["commands"]] if obj.get("commands") is not None else None,
            "schemaVersion": obj.get("schemaVersion") if obj.get("schemaVersion") is not None else '1.0'
        })
        return _obj


