# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.provider_metadata import ProviderMetadata
from devopso.clients.jira_cloud_agile.models.repository import Repository
from typing import Optional, Set
from typing_extensions import Self

class DevInformation(BaseModel):
    """
    Request object for development information push operations, entities are grouped by repository
    """ # noqa: E501
    repositories: Annotated[List[Repository], Field(max_length=100)] = Field(description="List of repositories containing development information. Must not contain duplicates. Maximum number of entities across all repositories is 1000.")
    prevent_transitions: Optional[StrictBool] = Field(default=None, description="Flag to prevent automatic issue transitions and smart commits being fired, default is false.", alias="preventTransitions")
    operation_type: Optional[StrictStr] = Field(default=None, description="Indicates the operation being performed by the provider system when sending this data. \"NORMAL\" - Data received during normal operation (e.g. a user pushing a branch). \"BACKFILL\" - Data received while backfilling existing data (e.g. indexing a newly connected account). Default is \"NORMAL\". Please note that \"BACKFILL\" operations have a much higher rate-limiting threshold but are also processed slower in comparison to \"NORMAL\" operations.", alias="operationType")
    properties: Optional[Dict[str, StrictStr]] = Field(default=None, description="Arbitrary properties to tag the submitted repositories with. These properties can be used for delete operations to e.g. clean up all development information associated with an account in the event that the account is removed from the provider system. Note that these properties will never be returned with repository or entity data. They are not intended for use as metadata to associate with a repository. Maximum length of each key or value is 255 characters. Maximum allowed number of properties key/value pairs is 5. Properties keys cannot start with '_' character. Properties keys cannot contain ':' character. ")
    provider_metadata: Optional[ProviderMetadata] = Field(default=None, alias="providerMetadata")
    __properties: ClassVar[List[str]] = ["repositories", "preventTransitions", "operationType", "properties", "providerMetadata"]

    @field_validator('operation_type')
    def operation_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NORMAL', 'BACKFILL']):
            raise ValueError("must be one of enum values ('NORMAL', 'BACKFILL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DevInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in repositories (list)
        _items = []
        if self.repositories:
            for _item_repositories in self.repositories:
                if _item_repositories:
                    _items.append(_item_repositories.to_dict())
            _dict['repositories'] = _items
        # override the default output from pydantic by calling `to_dict()` of provider_metadata
        if self.provider_metadata:
            _dict['providerMetadata'] = self.provider_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DevInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "repositories": [Repository.from_dict(_item) for _item in obj["repositories"]] if obj.get("repositories") is not None else None,
            "preventTransitions": obj.get("preventTransitions"),
            "operationType": obj.get("operationType"),
            "properties": obj.get("properties"),
            "providerMetadata": ProviderMetadata.from_dict(obj["providerMetadata"]) if obj.get("providerMetadata") is not None else None
        })
        return _obj


