# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.feature_flag_details import FeatureFlagDetails
from devopso.clients.jira_cloud_agile.models.feature_flag_summary import FeatureFlagSummary
from devopso.clients.jira_cloud_agile.models.issue_id_or_keys_association import IssueIdOrKeysAssociation
from typing import Optional, Set
from typing_extensions import Self

class FeatureFlagData(BaseModel):
    """
    Data related to a single Feature Flag, across any Environment that the flag is present in. 
    """ # noqa: E501
    schema_version: Optional[StrictStr] = Field(default='1.0', description="The FeatureFlagData schema version used for this flag data.   Placeholder to support potential schema changes in the future. ", alias="schemaVersion")
    id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The identifier for the Feature Flag. Must be unique for a given Provider. ")
    key: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The identifier that users would use to reference the Feature Flag in their source code etc.  Will be made available via the UI for users to copy into their source code etc. ")
    update_sequence_id: StrictInt = Field(description="An ID used to apply an ordering to updates for this Feature Flag in the case of out-of-order receipt of update requests.  This can be any monotonically increasing number. A suggested implementation is to use epoch millis from the Provider system, but other alternatives are valid (e.g. a Provider could store a counter against each Feature Flag and increment that on each update to Jira).  Updates for a Feature Flag that are received with an updateSqeuenceId lower than what is currently stored will be ignored. ", alias="updateSequenceId")
    display_name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The human-readable name for the Feature Flag. Will be shown in the UI.  If not provided, will use the ID for display. ", alias="displayName")
    issue_keys: Optional[Annotated[List[Annotated[str, Field(strict=True)]], Field(min_length=1, max_length=100)]] = Field(default=None, description="The Jira issue keys to associate the Feature Flag information with. ", alias="issueKeys")
    associations: Optional[List[IssueIdOrKeysAssociation]] = Field(default=None, description="The Jira issue keys or IDs to associate the feature flag with.")
    summary: FeatureFlagSummary
    details: Annotated[List[FeatureFlagDetails], Field(min_length=1)] = Field(description="Detail information for this Feature Flag.  This may be information for each environment the Feature Flag is defined in or a selection of environments made by the user, as appropriate. ")
    __properties: ClassVar[List[str]] = ["schemaVersion", "id", "key", "updateSequenceId", "displayName", "issueKeys", "associations", "summary", "details"]

    @field_validator('schema_version')
    def schema_version_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['1.0']):
            raise ValueError("must be one of enum values ('1.0')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FeatureFlagData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associations (list)
        _items = []
        if self.associations:
            for _item_associations in self.associations:
                if _item_associations:
                    _items.append(_item_associations.to_dict())
            _dict['associations'] = _items
        # override the default output from pydantic by calling `to_dict()` of summary
        if self.summary:
            _dict['summary'] = self.summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in details (list)
        _items = []
        if self.details:
            for _item_details in self.details:
                if _item_details:
                    _items.append(_item_details.to_dict())
            _dict['details'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FeatureFlagData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemaVersion": obj.get("schemaVersion") if obj.get("schemaVersion") is not None else '1.0',
            "id": obj.get("id"),
            "key": obj.get("key"),
            "updateSequenceId": obj.get("updateSequenceId"),
            "displayName": obj.get("displayName"),
            "issueKeys": obj.get("issueKeys"),
            "associations": [IssueIdOrKeysAssociation.from_dict(_item) for _item in obj["associations"]] if obj.get("associations") is not None else None,
            "summary": FeatureFlagSummary.from_dict(obj["summary"]) if obj.get("summary") is not None else None,
            "details": [FeatureFlagDetails.from_dict(_item) for _item in obj["details"]] if obj.get("details") is not None else None
        })
        return _obj


