# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.environment_details import EnvironmentDetails
from devopso.clients.jira_cloud_agile.models.feature_flag_status import FeatureFlagStatus
from typing import Optional, Set
from typing_extensions import Self

class FeatureFlagDetails(BaseModel):
    """
    Details of a Feature Flag for a single environment.
    """ # noqa: E501
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="A URL users can use to link to this Feature Flag, in this environment. ")
    last_updated: datetime = Field(description="The last-updated timestamp for this Feature Flag, in this environment.  Expected format is an RFC3339 formatted string. ", alias="lastUpdated")
    environment: EnvironmentDetails
    status: FeatureFlagStatus
    __properties: ClassVar[List[str]] = ["url", "lastUpdated", "environment", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FeatureFlagDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FeatureFlagDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "lastUpdated": obj.get("lastUpdated"),
            "environment": EnvironmentDetails.from_dict(obj["environment"]) if obj.get("environment") is not None else None,
            "status": FeatureFlagStatus.from_dict(obj["status"]) if obj.get("status") is not None else None
        })
        return _obj


