# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.feature_flag_rollout import FeatureFlagRollout
from typing import Optional, Set
from typing_extensions import Self

class FeatureFlagStatus(BaseModel):
    """
    Status information about a single Feature Flag. 
    """ # noqa: E501
    enabled: StrictBool = Field(description="Whether the Feature Flag is enabled in the given environment (or in summary).  Enabled may imply a partial rollout, which can be described using the 'rollout' field. ")
    default_value: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The value served by this Feature Flag when it is disabled. This could be the actual value or an alias, as appropriate.  This value may be presented to the user in the UI. ", alias="defaultValue")
    rollout: Optional[FeatureFlagRollout] = None
    __properties: ClassVar[List[str]] = ["enabled", "defaultValue", "rollout"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FeatureFlagStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rollout
        if self.rollout:
            _dict['rollout'] = self.rollout.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FeatureFlagStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enabled": obj.get("enabled"),
            "defaultValue": obj.get("defaultValue"),
            "rollout": FeatureFlagRollout.from_dict(obj["rollout"]) if obj.get("rollout") is not None else None
        })
        return _obj


