# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class File(BaseModel):
    """
    Describes changes to a file
    """ # noqa: E501
    path: Annotated[str, Field(strict=True, max_length=1024)] = Field(description="The path of the file. Max length is 1024 characters.")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="The URL of this file. Max length is 2000 characters.")
    change_type: StrictStr = Field(description="The operation performed on this file", alias="changeType")
    lines_added: Annotated[int, Field(strict=True, ge=0)] = Field(description="Number of lines added to the file", alias="linesAdded")
    lines_removed: Annotated[int, Field(strict=True, ge=0)] = Field(description="Number of lines removed from the file", alias="linesRemoved")
    __properties: ClassVar[List[str]] = ["path", "url", "changeType", "linesAdded", "linesRemoved"]

    @field_validator('change_type')
    def change_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ADDED', 'COPIED', 'DELETED', 'MODIFIED', 'MOVED', 'UNKNOWN']):
            raise ValueError("must be one of enum values ('ADDED', 'COPIED', 'DELETED', 'MODIFIED', 'MOVED', 'UNKNOWN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of File from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of File from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "path": obj.get("path"),
            "url": obj.get("url"),
            "changeType": obj.get("changeType"),
            "linesAdded": obj.get("linesAdded"),
            "linesRemoved": obj.get("linesRemoved")
        })
        return _obj


