# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.create_board_request_location import CreateBoardRequestLocation
from devopso.clients.jira_cloud_agile.models.get_configuration200_response_column_config import GetConfiguration200ResponseColumnConfig
from devopso.clients.jira_cloud_agile.models.get_configuration200_response_column_config_columns_inner_statuses_inner import GetConfiguration200ResponseColumnConfigColumnsInnerStatusesInner
from devopso.clients.jira_cloud_agile.models.get_configuration200_response_estimation import GetConfiguration200ResponseEstimation
from devopso.clients.jira_cloud_agile.models.get_configuration200_response_ranking import GetConfiguration200ResponseRanking
from devopso.clients.jira_cloud_agile.models.get_configuration200_response_sub_query import GetConfiguration200ResponseSubQuery
from typing import Optional, Set
from typing_extensions import Self

class GetConfiguration200Response(BaseModel):
    """
    GetConfiguration200Response
    """ # noqa: E501
    column_config: Optional[GetConfiguration200ResponseColumnConfig] = Field(default=None, alias="columnConfig")
    estimation: Optional[GetConfiguration200ResponseEstimation] = None
    filter: Optional[GetConfiguration200ResponseColumnConfigColumnsInnerStatusesInner] = None
    id: Optional[StrictInt] = None
    location: Optional[CreateBoardRequestLocation] = None
    name: Optional[StrictStr] = None
    ranking: Optional[GetConfiguration200ResponseRanking] = None
    var_self: Optional[StrictStr] = Field(default=None, alias="self")
    sub_query: Optional[GetConfiguration200ResponseSubQuery] = Field(default=None, alias="subQuery")
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["columnConfig", "estimation", "filter", "id", "location", "name", "ranking", "self", "subQuery", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetConfiguration200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of column_config
        if self.column_config:
            _dict['columnConfig'] = self.column_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of estimation
        if self.estimation:
            _dict['estimation'] = self.estimation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filter
        if self.filter:
            _dict['filter'] = self.filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ranking
        if self.ranking:
            _dict['ranking'] = self.ranking.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sub_query
        if self.sub_query:
            _dict['subQuery'] = self.sub_query.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetConfiguration200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "columnConfig": GetConfiguration200ResponseColumnConfig.from_dict(obj["columnConfig"]) if obj.get("columnConfig") is not None else None,
            "estimation": GetConfiguration200ResponseEstimation.from_dict(obj["estimation"]) if obj.get("estimation") is not None else None,
            "filter": GetConfiguration200ResponseColumnConfigColumnsInnerStatusesInner.from_dict(obj["filter"]) if obj.get("filter") is not None else None,
            "id": obj.get("id"),
            "location": CreateBoardRequestLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "name": obj.get("name"),
            "ranking": GetConfiguration200ResponseRanking.from_dict(obj["ranking"]) if obj.get("ranking") is not None else None,
            "self": obj.get("self"),
            "subQuery": GetConfiguration200ResponseSubQuery.from_dict(obj["subQuery"]) if obj.get("subQuery") is not None else None,
            "type": obj.get("type")
        })
        return _obj


