# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.get_features_for_board200_response_features_inner_permissible_estimation_types_inner import GetFeaturesForBoard200ResponseFeaturesInnerPermissibleEstimationTypesInner
from typing import Optional, Set
from typing_extensions import Self

class GetFeaturesForBoard200ResponseFeaturesInner(BaseModel):
    """
    GetFeaturesForBoard200ResponseFeaturesInner
    """ # noqa: E501
    board_feature: Optional[StrictStr] = Field(default=None, alias="boardFeature")
    board_id: Optional[StrictInt] = Field(default=None, alias="boardId")
    feature_id: Optional[StrictStr] = Field(default=None, alias="featureId")
    feature_type: Optional[StrictStr] = Field(default=None, alias="featureType")
    image_uri: Optional[StrictStr] = Field(default=None, alias="imageUri")
    learn_more_article_id: Optional[StrictStr] = Field(default=None, alias="learnMoreArticleId")
    learn_more_link: Optional[StrictStr] = Field(default=None, alias="learnMoreLink")
    localised_description: Optional[StrictStr] = Field(default=None, alias="localisedDescription")
    localised_group: Optional[StrictStr] = Field(default=None, alias="localisedGroup")
    localised_name: Optional[StrictStr] = Field(default=None, alias="localisedName")
    permissible_estimation_types: Optional[List[GetFeaturesForBoard200ResponseFeaturesInnerPermissibleEstimationTypesInner]] = Field(default=None, alias="permissibleEstimationTypes")
    state: Optional[StrictStr] = None
    toggle_locked: Optional[StrictBool] = Field(default=None, alias="toggleLocked")
    __properties: ClassVar[List[str]] = ["boardFeature", "boardId", "featureId", "featureType", "imageUri", "learnMoreArticleId", "learnMoreLink", "localisedDescription", "localisedGroup", "localisedName", "permissibleEstimationTypes", "state", "toggleLocked"]

    @field_validator('board_feature')
    def board_feature_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SIMPLE_ROADMAP', 'BACKLOG', 'SPRINTS', 'CALENDAR', 'DEVTOOLS', 'REPORTS', 'ESTIMATION', 'PAGES', 'CODE', 'SECURITY', 'REQUESTS', 'INCIDENTS', 'RELEASES', 'DEPLOYMENTS', 'ISSUE_NAVIGATOR', 'ON_CALL_SCHEDULE', 'BOARD', 'GOALS', 'LIST_VIEW']):
            raise ValueError("must be one of enum values ('SIMPLE_ROADMAP', 'BACKLOG', 'SPRINTS', 'CALENDAR', 'DEVTOOLS', 'REPORTS', 'ESTIMATION', 'PAGES', 'CODE', 'SECURITY', 'REQUESTS', 'INCIDENTS', 'RELEASES', 'DEPLOYMENTS', 'ISSUE_NAVIGATOR', 'ON_CALL_SCHEDULE', 'BOARD', 'GOALS', 'LIST_VIEW')")
        return value

    @field_validator('feature_type')
    def feature_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['BASIC', 'ESTIMATION']):
            raise ValueError("must be one of enum values ('BASIC', 'ESTIMATION')")
        return value

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ENABLED', 'DISABLED', 'COMING_SOON']):
            raise ValueError("must be one of enum values ('ENABLED', 'DISABLED', 'COMING_SOON')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetFeaturesForBoard200ResponseFeaturesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in permissible_estimation_types (list)
        _items = []
        if self.permissible_estimation_types:
            for _item_permissible_estimation_types in self.permissible_estimation_types:
                if _item_permissible_estimation_types:
                    _items.append(_item_permissible_estimation_types.to_dict())
            _dict['permissibleEstimationTypes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetFeaturesForBoard200ResponseFeaturesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "boardFeature": obj.get("boardFeature"),
            "boardId": obj.get("boardId"),
            "featureId": obj.get("featureId"),
            "featureType": obj.get("featureType"),
            "imageUri": obj.get("imageUri"),
            "learnMoreArticleId": obj.get("learnMoreArticleId"),
            "learnMoreLink": obj.get("learnMoreLink"),
            "localisedDescription": obj.get("localisedDescription"),
            "localisedGroup": obj.get("localisedGroup"),
            "localisedName": obj.get("localisedName"),
            "permissibleEstimationTypes": [GetFeaturesForBoard200ResponseFeaturesInnerPermissibleEstimationTypesInner.from_dict(_item) for _item in obj["permissibleEstimationTypes"]] if obj.get("permissibleEstimationTypes") is not None else None,
            "state": obj.get("state"),
            "toggleLocked": obj.get("toggleLocked")
        })
        return _obj


