# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.associations import Associations
from devopso.clients.jira_cloud_agile.models.incident_severity import IncidentSeverity
from typing import Optional, Set
from typing_extensions import Self

class Incident(BaseModel):
    """
    Data related to a specific incident in a specific container that the incident is present in. Must specify at least one association to a component. 
    """ # noqa: E501
    schema_version: StrictStr = Field(description="The IncidentData schema version used for this incident data.  Placeholder to support potential schema changes in the future. ", alias="schemaVersion")
    id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The identifier for the Incident. Must be unique for a given Provider. ")
    update_sequence_number: StrictInt = Field(description="An ID used to apply an ordering to updates for this Incident in the case of out-of-order receipt of update requests.  This can be any monotonically increasing number. A suggested implementation is to use epoch millis from the Provider system, but other alternatives are valid (e.g. a Provider could store a counter against each Incident and increment that on each update to Jira).  Updates for a Incident that are received with an updateSqeuenceId lower than what is currently stored will be ignored. ", alias="updateSequenceNumber")
    affected_components: Annotated[List[StrictStr], Field(min_length=1, max_length=100)] = Field(description="The IDs of the Components impacted by this Incident. Must be unique for a given Provider. ", alias="affectedComponents")
    summary: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The human-readable summary for the Incident. Will be shown in the UI.  If not provided, will use the ID for display. ")
    description: Annotated[str, Field(strict=True, max_length=5000)] = Field(description="A description of the issue in Markdown format. Will be shown in the UI and used when creating Jira Issues. ")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="A URL users can use to link to a summary view of this incident, if appropriate.  This could be any location that makes sense in the Provider system (e.g. if the summary information comes from a specific project, it might make sense to link the user to the incident in that project). ")
    created_date: datetime = Field(description="The timestamp to present to the user that shows when the Incident was raised.  Expected format is an RFC3339 formatted string. ", alias="createdDate")
    last_updated: datetime = Field(description="The last-updated timestamp to present to the user the last time the Incident was updated.  Expected format is an RFC3339 formatted string. ", alias="lastUpdated")
    severity: Optional[IncidentSeverity] = None
    status: StrictStr = Field(description="The current status of the Incident. ")
    associations: Optional[Annotated[List[Associations], Field(min_length=1, max_length=100)]] = Field(default=None, description="The IDs of the Jira issues related to this Incident. Must be unique for a given Provider. ")
    __properties: ClassVar[List[str]] = ["schemaVersion", "id", "updateSequenceNumber", "affectedComponents", "summary", "description", "url", "createdDate", "lastUpdated", "severity", "status", "associations"]

    @field_validator('schema_version')
    def schema_version_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['1.0']):
            raise ValueError("must be one of enum values ('1.0')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['open', 'resolved', 'unknown']):
            raise ValueError("must be one of enum values ('open', 'resolved', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Incident from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of severity
        if self.severity:
            _dict['severity'] = self.severity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in associations (list)
        _items = []
        if self.associations:
            for _item_associations in self.associations:
                if _item_associations:
                    _items.append(_item_associations.to_dict())
            _dict['associations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Incident from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemaVersion": obj.get("schemaVersion") if obj.get("schemaVersion") is not None else '1.0',
            "id": obj.get("id"),
            "updateSequenceNumber": obj.get("updateSequenceNumber"),
            "affectedComponents": obj.get("affectedComponents"),
            "summary": obj.get("summary"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "createdDate": obj.get("createdDate"),
            "lastUpdated": obj.get("lastUpdated"),
            "severity": IncidentSeverity.from_dict(obj["severity"]) if obj.get("severity") is not None else None,
            "status": obj.get("status"),
            "associations": [Associations.from_dict(_item) for _item in obj["associations"]] if obj.get("associations") is not None else None
        })
        return _obj


