# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class JsonTypeBean(BaseModel):
    """
    The schema of a field.
    """ # noqa: E501
    configuration: Optional[Dict[str, Any]] = Field(default=None, description="If the field is a custom field, the configuration of the field.")
    custom: Optional[StrictStr] = Field(default=None, description="If the field is a custom field, the URI of the field.")
    custom_id: Optional[StrictInt] = Field(default=None, description="If the field is a custom field, the custom ID of the field.", alias="customId")
    items: Optional[StrictStr] = Field(default=None, description="When the data type is an array, the name of the field items within the array.")
    system: Optional[StrictStr] = Field(default=None, description="If the field is a system field, the name of the field.")
    type: StrictStr = Field(description="The data type of the field.")
    __properties: ClassVar[List[str]] = ["configuration", "custom", "customId", "items", "system", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JsonTypeBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "configuration",
            "custom",
            "custom_id",
            "items",
            "system",
            "type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JsonTypeBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "configuration": obj.get("configuration"),
            "custom": obj.get("custom"),
            "customId": obj.get("customId"),
            "items": obj.get("items"),
            "system": obj.get("system"),
            "type": obj.get("type")
        })
        return _obj


