# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.issue_bean_changelog_all_of_histories_inner import IssueBeanChangelogAllOfHistoriesInner
from typing import Optional, Set
from typing_extensions import Self

class PageOfChangelogs(BaseModel):
    """
    A page of changelogs.
    """ # noqa: E501
    histories: Optional[List[IssueBeanChangelogAllOfHistoriesInner]] = Field(default=None, description="The list of changelogs.")
    max_results: Optional[StrictInt] = Field(default=None, description="The maximum number of results that could be on the page.", alias="maxResults")
    start_at: Optional[StrictInt] = Field(default=None, description="The index of the first item returned on the page.", alias="startAt")
    total: Optional[StrictInt] = Field(default=None, description="The number of results on the page.")
    __properties: ClassVar[List[str]] = ["histories", "maxResults", "startAt", "total"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PageOfChangelogs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "histories",
            "max_results",
            "start_at",
            "total",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in histories (list)
        _items = []
        if self.histories:
            for _item_histories in self.histories:
                if _item_histories:
                    _items.append(_item_histories.to_dict())
            _dict['histories'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PageOfChangelogs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "histories": [IssueBeanChangelogAllOfHistoriesInner.from_dict(_item) for _item in obj["histories"]] if obj.get("histories") is not None else None,
            "maxResults": obj.get("maxResults"),
            "startAt": obj.get("startAt"),
            "total": obj.get("total")
        })
        return _obj


